/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.AllProjectsContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ContextSetUtil {
    private static final ContextSetUtil INSTANCE = new ContextSetUtil();

    public static ContextSetUtil getInstance() {
        return INSTANCE;
    }

    public ClauseContext intersect(Set<? extends ClauseContext> childClauseContexts) {
        Assertions.containsNoNulls("childClauseContexts", childClauseContexts);
        if (childClauseContexts.isEmpty()) {
            return new ClauseContextImpl();
        }
        Iterator<? extends ClauseContext> iter = childClauseContexts.iterator();
        Set<ProjectIssueTypeContext> intersection = iter.next().getContexts();
        while (iter.hasNext()) {
            Set<ProjectIssueTypeContext> toIntersect = iter.next().getContexts();
            HashSet<ProjectIssueTypeContext> intersectionResults = new HashSet<ProjectIssueTypeContext>();
            for (ProjectIssueTypeContext toIntersectContext : toIntersect) {
                for (ProjectIssueTypeContext intersectionContext : intersection) {
                    if (!this.contextsEquiliaventForIntersection(toIntersectContext, intersectionContext)) continue;
                    intersectionResults.add(this.combineContexts(toIntersectContext, intersectionContext));
                }
            }
            intersection = intersectionResults;
        }
        return new ClauseContextImpl(intersection);
    }

    public ClauseContext union(Set<? extends ClauseContext> childClauseContexts) {
        Assertions.containsNoNulls("childClauseContexts", childClauseContexts);
        if (childClauseContexts.isEmpty()) {
            return new ClauseContextImpl();
        }
        Iterator<? extends ClauseContext> iter = childClauseContexts.iterator();
        HashSet<ProjectIssueTypeContext> union = new HashSet<ProjectIssueTypeContext>(iter.next().getContexts());
        while (iter.hasNext()) {
            Set<ProjectIssueTypeContext> toUnion = iter.next().getContexts();
            HashSet<ProjectIssueTypeContext> unionResults = new HashSet<ProjectIssueTypeContext>();
            for (ProjectIssueTypeContext toUnionContext : toUnion) {
                boolean matched = false;
                Iterator iterator = union.iterator();
                while (iterator.hasNext()) {
                    ProjectIssueTypeContext unionContext = (ProjectIssueTypeContext)iterator.next();
                    if (!this.contextsEquiliaventForUnion(toUnionContext, unionContext)) continue;
                    matched = true;
                    iterator.remove();
                    unionResults.add(this.combineContexts(toUnionContext, unionContext));
                }
                if (matched) continue;
                unionResults.add(toUnionContext);
            }
            union.addAll(unionResults);
        }
        return new ClauseContextImpl(union);
    }

    private boolean contextsEquiliaventForIntersection(ProjectIssueTypeContext one, ProjectIssueTypeContext two) {
        return !(!one.getIssueTypeContext().isAll() && !two.getIssueTypeContext().isAll() && !one.getIssueTypeContext().getIssueTypeId().equals(two.getIssueTypeContext().getIssueTypeId()) || !one.getProjectContext().isAll() && !two.getProjectContext().isAll() && !one.getProjectContext().getProjectId().equals(two.getProjectContext().getProjectId()));
    }

    private boolean contextsEquiliaventForUnion(ProjectIssueTypeContext one, ProjectIssueTypeContext two) {
        return this.issueTypeValuesEqualForUnion(one.getIssueTypeContext(), two.getIssueTypeContext()) && this.projectValuesEqualForUnion(one.getProjectContext(), two.getProjectContext());
    }

    private boolean projectValuesEqualForUnion(ProjectContext one, ProjectContext two) {
        if (one.isAll() && two.isAll()) {
            return true;
        }
        if (one.isAll() || two.isAll()) {
            return false;
        }
        return one.getProjectId().equals(two.getProjectId());
    }

    private boolean issueTypeValuesEqualForUnion(IssueTypeContext one, IssueTypeContext two) {
        if (one.isAll() && two.isAll()) {
            return true;
        }
        if (one.isAll() || two.isAll()) {
            return false;
        }
        return one.getIssueTypeId().equals(two.getIssueTypeId());
    }

    private ProjectIssueTypeContext combineContexts(ProjectIssueTypeContext one, ProjectIssueTypeContext two) {
        IssueTypeContext issueTypeContext = one.getIssueTypeContext().isAll() && two.getIssueTypeContext().isAll() ? AllIssueTypesContext.INSTANCE : (one.getIssueTypeContext().isAll() ? two.getIssueTypeContext() : (two.getIssueTypeContext().isAll() ? one.getIssueTypeContext() : new IssueTypeContextImpl(one.getIssueTypeContext().getIssueTypeId())));
        ProjectContext projectContext = one.getProjectContext().isAll() && two.getProjectContext().isAll() ? AllProjectsContext.INSTANCE : (one.getProjectContext().isAll() ? two.getProjectContext() : (two.getProjectContext().isAll() ? one.getProjectContext() : new ProjectContextImpl(one.getProjectContext().getProjectId())));
        return new ProjectIssueTypeContextImpl(projectContext, issueTypeContext);
    }
}

