/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

@PublicApi
public class TemporaryAttachmentsMonitor
implements HttpSessionBindingListener {
    private final Map<Long, TemporaryAttachment> temporaryAttachments = new HashMap<Long, TemporaryAttachment>();

    public void add(TemporaryAttachment temporaryAttachment) {
        this.temporaryAttachments.put(temporaryAttachment.getId(), temporaryAttachment);
    }

    public TemporaryAttachment getById(Long id) {
        return this.temporaryAttachments.get(id);
    }

    public Collection<TemporaryAttachment> getByIssueId(final Long issueId) {
        ArrayList<TemporaryAttachment> ret = new ArrayList<TemporaryAttachment>(CollectionUtil.filter(this.temporaryAttachments.values(), new Predicate<TemporaryAttachment>(){

            @Override
            public boolean evaluate(TemporaryAttachment input) {
                return issueId == null && input.getIssueId() == null || issueId != null && issueId.equals(input.getIssueId());
            }
        }));
        Collections.sort(ret);
        return ret;
    }

    public void clearEntriesForIssue(Long issueId) {
        Collection<TemporaryAttachment> attachmentsForIssueId = this.getByIssueId(issueId);
        for (TemporaryAttachment temporaryAttachment : attachmentsForIssueId) {
            temporaryAttachment.getFile().delete();
            this.temporaryAttachments.remove(temporaryAttachment.getId());
        }
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        for (TemporaryAttachment temporaryAttachment : this.temporaryAttachments.values()) {
            temporaryAttachment.getFile().delete();
        }
        this.temporaryAttachments.clear();
    }
}

