/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class LabelsStatisticsMapper
implements StatisticsMapper {
    private final String clauseName;
    private final String indexedField;
    private final boolean includeEmpty;

    public LabelsStatisticsMapper(boolean includeEmpty) {
        this(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forLabels().getIndexField(), includeEmpty);
    }

    public LabelsStatisticsMapper(String clauseName, String indexedField, boolean includeEmpty) {
        this.clauseName = Assertions.notBlank("clauseName", clauseName);
        this.indexedField = Assertions.notBlank("indexedField", indexedField);
        this.includeEmpty = includeEmpty;
    }

    @Override
    public Comparator getComparator() {
        return LabelComparator.INSTANCE;
    }

    public boolean isValidValue(Object value) {
        return value != null || this.includeEmpty;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        if (StringUtils.isEmpty((String)documentValue) || "<EMPTY>".equals(documentValue)) {
            return null;
        }
        return new Label(null, null, documentValue);
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder(searchRequest.getQuery()).where().defaultAnd();
        if (value != null) {
            builder.labels(((Label)value).getLabel());
        } else {
            builder.addEmptyCondition(this.getClauseName());
        }
        return new SearchRequest(builder.buildQuery());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public String getDocumentConstant() {
        return this.indexedField;
    }
}

