/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssuePage;
import com.atlassian.jira.web.component.IssuePager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@PublicApi
public class SearchResults
implements IssuePager {
    private Collection<Page> pages;
    private static final int PAGES_TO_LIST = 5;
    private final int start;
    private final int max;
    private final int total;
    private final List<Issue> issues;

    public SearchResults(List<Issue> issues, PagerFilter<Issue> pagerFilter) {
        if (issues.size() < pagerFilter.getStart()) {
            pagerFilter.setStart(0);
        }
        this.start = pagerFilter.getStart();
        this.total = issues.size();
        this.max = pagerFilter.getMax();
        this.issues = pagerFilter.getCurrentPage(issues);
    }

    public SearchResults(List<Issue> issuesInPage, int totalIssueCount, PagerFilter pagerFilter) {
        if (totalIssueCount < pagerFilter.getStart()) {
            pagerFilter.setStart(0);
        }
        this.start = pagerFilter.getStart();
        this.total = totalIssueCount;
        this.max = pagerFilter.getMax();
        this.issues = issuesInPage;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return Math.min(this.start + this.max, this.total);
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getNextStart() {
        return this.start + this.max;
    }

    @Override
    public int getPreviousStart() {
        return Math.max(0, this.start - this.max);
    }

    public int getNiceStart() {
        if (this.getIssues() == null || this.getIssues().size() == 0) {
            return 0;
        }
        return this.getStart() + 1;
    }

    @Override
    public List<Page> getPages() {
        if (this.pages == null) {
            this.pages = this.generatePages();
        }
        return this.restrictPages(this.pages, this.total);
    }

    List<Page> generatePages() {
        if (this.total == 0) {
            return Collections.emptyList();
        }
        if (this.max <= 0) {
            throw new IllegalArgumentException("Issue per page should be 1 or greater.");
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        int pageNumber = 1;
        for (int index = 0; index < this.total; index += this.max) {
            boolean isCurrentPage = this.start >= index && this.start < index + this.max;
            pages.add(new Page(index, pageNumber, isCurrentPage));
            ++pageNumber;
        }
        return pages;
    }

    List<Page> restrictPages(Collection<Page> pages, int size) {
        ArrayList<Page> pagesToDisplay = new ArrayList<Page>(10);
        int firstpage = 1;
        int lastpage = firstpage + 5 + 5 - 2;
        int maxpage = (size + this.max - 1) / this.max;
        if (lastpage < maxpage) {
            int ourpage = this.getStart() / this.max + 1;
            if (ourpage - firstpage > 4) {
                lastpage = ourpage + 5 - 1;
                if (lastpage > maxpage) {
                    lastpage = maxpage;
                }
                firstpage = lastpage - 5 - 5 + 2;
            }
        } else if (lastpage > maxpage) {
            lastpage = maxpage;
        }
        int minstart = (firstpage - 1) * this.max;
        int maxstart = (lastpage - 1) * this.max;
        for (Page page : pages) {
            boolean smallerThanMax;
            if (page.getStart() > size) continue;
            boolean largerThanMin = page.getStart() >= minstart;
            boolean bl = smallerThanMax = page.getStart() <= maxstart;
            if (!largerThanMin || !smallerThanMax) continue;
            pagesToDisplay.add(page);
        }
        return pagesToDisplay;
    }

    static class Page
    implements IssuePage {
        private final int start;
        private final int pageNumber;
        private final boolean currentPage;

        public Page(int start, int pageNumber, boolean isCurrentPage) {
            this.start = start;
            this.pageNumber = pageNumber;
            this.currentPage = isCurrentPage;
        }

        @Override
        public boolean isCurrentPage() {
            return this.currentPage;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getPageNumber() {
            return this.pageNumber;
        }
    }
}

