/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group;

import com.atlassian.core.util.collection.EasyList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupRemoveChildMapper {
    private final List defaultGroupNames;
    private final Map groupsToRemoveByChildName;

    public GroupRemoveChildMapper() {
        this(Collections.EMPTY_LIST);
    }

    public GroupRemoveChildMapper(List defaultGroupNames) {
        if (defaultGroupNames == null) {
            throw new IllegalArgumentException("defaultGroupNames cannot be null");
        }
        this.defaultGroupNames = defaultGroupNames;
        this.groupsToRemoveByChildName = new HashMap();
    }

    public GroupRemoveChildMapper register(String childName) {
        if (this.groupsToRemoveByChildName.get(childName) == null) {
            this.groupsToRemoveByChildName.put(childName, new HashSet());
        }
        return this;
    }

    public GroupRemoveChildMapper register(String childName, String groupName) {
        return this.register(childName, EasyList.build((Object)groupName));
    }

    public GroupRemoveChildMapper register(String childName, Collection groupNames) {
        if (groupNames != null && !groupNames.isEmpty()) {
            if (this.groupsToRemoveByChildName.get(childName) == null) {
                this.groupsToRemoveByChildName.put(childName, new HashSet());
            }
            HashSet groups = (HashSet)this.groupsToRemoveByChildName.get(childName);
            groups.addAll(groupNames);
        }
        return this;
    }

    public boolean isRemoveFromAllSelected(String childName) {
        Set groups = (Set)this.groupsToRemoveByChildName.get(childName);
        return groups != null && groups.isEmpty();
    }

    public Iterator getGroupsIterator(String childName) {
        return this.getGroups(childName).iterator();
    }

    public Collection getGroups(String childName) {
        Collection groups = this.isRemoveFromAllSelected(childName) ? Collections.unmodifiableList(this.defaultGroupNames) : Collections.unmodifiableSet((Set)this.groupsToRemoveByChildName.get(childName));
        if (groups == null) {
            return Collections.EMPTY_LIST;
        }
        return groups;
    }

    public Iterator childIterator() {
        return this.groupsToRemoveByChildName.keySet().iterator();
    }

    public List getDefaultGroupNames() {
        return Collections.unmodifiableList(this.defaultGroupNames);
    }
}

