/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.changehistory.ChangeHistoryFieldConstants;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ChangeHistoryFieldIdResolver {
    private final ChangeHistoryFieldConstants changeHistoryFieldConstants;
    private final VersionResolver versionResolver;
    private final ConstantsManager constantsManager;
    private final LazyReference<Map<String, List<String>>> ref = new LazyReference<Map<String, List<String>>>(){

        protected Map<String, List<String>> create() throws Exception {
            return Maps.newHashMap();
        }
    };

    public ChangeHistoryFieldIdResolver(ChangeHistoryFieldConstants changeHistoryFieldConstants, VersionResolver versionResolver, ConstantsManager constantsManager) {
        this.changeHistoryFieldConstants = changeHistoryFieldConstants;
        this.versionResolver = versionResolver;
        this.constantsManager = constantsManager;
    }

    public Collection<String> resolveIdsForField(String field, QueryLiteral literal, boolean emptyOperand) {
        Collection<String> ids = this.getIdsForName(field, literal, emptyOperand);
        if (ids.isEmpty()) {
            ids = emptyOperand ? Collections.singleton("-1") : Collections.singleton(literal.getLongValue() != null ? literal.getLongValue().toString() : literal.getStringValue());
        }
        return ids;
    }

    private Collection<String> getIdsForName(String field, QueryLiteral literal, boolean emptyOperand) {
        String value;
        Collection<String> ids = Collections.emptySet();
        String string = value = literal.getLongValue() != null ? literal.getLongValue().toString() : literal.getStringValue();
        if (this.constantsManager.getConstantObjects(field) != null && !emptyOperand) {
            IssueConstant issueConstant = this.constantsManager.getConstantByNameIgnoreCase(field, value);
            ids = issueConstant == null ? this.changeHistoryFieldConstants.getIdsForField(field, literal) : Collections.singletonList(issueConstant.getId());
        } else if (!emptyOperand) {
            ids = this.resolveIdsForVersion(field, Collections.singleton(value));
        } else if (value != null) {
            ids = Collections.singleton(value);
        }
        return ids;
    }

    private Collection<String> resolveIdsForVersion(String field, Collection<String> stringValues) {
        HashSet ids = Sets.newHashSet();
        if (field.toLowerCase().equals("fixversion")) {
            for (String rawValue : stringValues) {
                List idsPerVersion = (List)((Map)this.ref.get()).get(rawValue);
                if (idsPerVersion == null) {
                    ((Map)this.ref.get()).put(rawValue, this.versionResolver.getIdsFromName(rawValue));
                    idsPerVersion = (List)((Map)this.ref.get()).get(rawValue);
                }
                ids.addAll(idsPerVersion);
            }
        } else {
            ids.addAll(stringValues);
        }
        return ids;
    }
}

