/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.jira.config.properties.ApplicationProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class DashboardUtil {
    private static final Logger log = Logger.getLogger(DashboardUtil.class);
    private static final int MAX_GADGETS_DEFAULT = 20;

    private DashboardUtil() {
    }

    public static Long toLong(DashboardId dashboardId) {
        return dashboardId == null ? null : Long.valueOf(dashboardId.value());
    }

    public static Long toLong(GadgetId gadgetId) {
        return gadgetId == null ? null : Long.valueOf(gadgetId.value());
    }

    public static int getMaxGadgets(ApplicationProperties applicationProperties) {
        String maxGadgetsString = applicationProperties.getDefaultBackedString("jira.dashboard.max.gadgets");
        if (StringUtils.isNotBlank((String)maxGadgetsString)) {
            try {
                return Integer.valueOf(maxGadgetsString);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("jira.dashboard.max.gadgets is not set to valid number value '" + maxGadgetsString + "'. Falling back to default"));
                return 20;
            }
        }
        return 20;
    }
}

