/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.LocalDate;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.GJChronology;

public class LocalDateFactory {
    public static LocalDate from(Date date) {
        if (date == null) {
            return null;
        }
        DateMidnight ld = new DateMidnight((Object)date, (Chronology)GJChronology.getInstance());
        return LocalDateFactory.from(ld);
    }

    public static LocalDate getLocalDate(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        DateMidnight ld = new DateMidnight(date.getTime(), DateTimeZone.forTimeZone((TimeZone)timeZone)).withChronology((Chronology)GJChronology.getInstance());
        return LocalDateFactory.from(ld);
    }

    private static LocalDate from(DateMidnight ld) {
        if (ld.getEra() != 1) {
            throw new IllegalArgumentException("LocalDate only handles the Common Era - no BC dates are allowed.");
        }
        int year = ld.getYearOfEra();
        int month = ld.getMonthOfYear();
        int day = ld.getDayOfMonth();
        return new LocalDate(year, month, day);
    }

    public static LocalDate fromIsoBasicFormat(String isoDate) {
        if (isoDate == null) {
            return null;
        }
        if (isoDate.length() != 8) {
            throw new IllegalArgumentException("Input must be in the format 'YYYYMMDD'.");
        }
        int year = Integer.parseInt(isoDate.substring(0, 4));
        int month = Integer.parseInt(isoDate.substring(4, 6));
        int day = Integer.parseInt(isoDate.substring(6, 8));
        return new LocalDate(year, month, day);
    }

    public static String toIsoBasic(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return LocalDateFactory.format4(localDate.getYear()) + LocalDateFactory.format2(localDate.getMonth()) + LocalDateFactory.format2(localDate.getDay());
    }

    private static String format4(int i) {
        if (i >= 1000 && i <= 9999) {
            return String.valueOf(i);
        }
        if (i >= 0 && i < 10) {
            return "000" + i;
        }
        if (i >= 10 && i < 100) {
            return "00" + i;
        }
        if (i >= 100 && i < 1000) {
            return "0" + i;
        }
        throw new IllegalArgumentException("Invalid value " + i + " must be between 0 and 9999");
    }

    private static String format2(int i) {
        if (i > 0 && i < 10) {
            return "0" + i;
        }
        if (i >= 10 && i < 100) {
            return String.valueOf(i);
        }
        throw new IllegalArgumentException("Invalid value " + i + " must be between 1 and 99");
    }
}

