/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.log4j.Logger;

public class SearchRequestUtils {
    private static final Logger log = Logger.getLogger(SearchRequestUtils.class);

    public static SearchContext getCombinedSearchContext(SearchContext baseSearchContext, SearchContext possibleContext) {
        if (baseSearchContext != null) {
            if (possibleContext != null) {
                List<String> combinedIssuetypes;
                List<Long> combinedProjects;
                if (baseSearchContext.isForAnyProjects()) {
                    combinedProjects = possibleContext.getProjectIds();
                } else {
                    combinedProjects = ListUtils.intersection(baseSearchContext.getProjectIds(), possibleContext.getProjectIds() != null ? possibleContext.getProjectIds() : Collections.EMPTY_LIST);
                    if (combinedProjects.isEmpty()) {
                        combinedProjects = baseSearchContext.getProjectIds();
                    }
                }
                if (baseSearchContext.isForAnyIssueTypes()) {
                    combinedIssuetypes = possibleContext.getIssueTypeIds();
                } else {
                    combinedIssuetypes = ListUtils.intersection(baseSearchContext.getIssueTypeIds(), possibleContext.getIssueTypeIds() != null ? possibleContext.getIssueTypeIds() : Collections.EMPTY_LIST);
                    if (combinedIssuetypes.isEmpty()) {
                        combinedIssuetypes = baseSearchContext.getIssueTypeIds();
                    }
                }
                SearchContextFactory searchContextFactory = ComponentAccessor.getComponent(SearchContextFactory.class);
                return searchContextFactory.create(null, combinedProjects, combinedIssuetypes);
            }
            SearchContextFactory searchContextFactory = ComponentAccessor.getComponent(SearchContextFactory.class);
            return searchContextFactory.create(baseSearchContext);
        }
        return null;
    }

    public static List<String> getSearchSortDescriptions(SearchRequest searchRequest, FieldManager fieldManager, SearchHandlerManager searchHandlerManager, SearchSortUtil searchSortUtil, I18nHelper i18nHelper, User searcher) {
        return ComponentAccessor.getComponent(SearchSortUtil.class).getSearchSortDescriptions(searchRequest, i18nHelper, searcher);
    }
}

