/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class RelationalOperatorIdIndexValueQueryFactory<T>
extends AbstractOperatorQueryFactory<T>
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(RelationalOperatorIdIndexValueQueryFactory.class);
    private final Comparator<? super T> comparator;
    private final NameResolver<T> resolver;
    private final IndexInfoResolver<T> indexInfoResolver;

    public RelationalOperatorIdIndexValueQueryFactory(Comparator<? super T> comparator, NameResolver<T> resolver, IndexInfoResolver<T> indexInfoResolver) {
        super(indexInfoResolver);
        this.indexInfoResolver = indexInfoResolver;
        this.comparator = Assertions.notNull("comparator", comparator);
        this.resolver = resolver;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.warn((Object)String.format("Create query for single value was called with operator '%s', this only handles relational operators.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<String> indexValues = this.getIndexValues(rawValues);
        if (indexValues == null || indexValues.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        if (indexValues.size() == 1) {
            Query query = this.generateQueryForValue(fieldName, operator, indexValues.get(0));
            if (query == null) {
                return QueryFactoryResult.createFalseResult();
            }
            return new QueryFactoryResult(query);
        }
        BooleanQuery query = new BooleanQuery();
        for (String id : indexValues) {
            Query subQuery;
            if (id == null || (subQuery = this.generateQueryForValue(fieldName, operator, id)) == null) continue;
            query.add(subQuery, BooleanClause.Occur.SHOULD);
        }
        return this.checkQueryForEmpty(query);
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.warn((Object)"Empty operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> listOfIds) {
        log.warn((Object)"Multi value operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }

    Query generateQueryForValue(String fieldName, Operator operator, String indexValue) {
        if (indexValue == null) {
            return null;
        }
        Long id = this.getValueAsLong(indexValue);
        T domainObject = this.resolver.get(id);
        Predicate<T> relationalOperatorMatch = this.createPredicate(operator, domainObject);
        return this.generateRangeQueryForPredicate(fieldName, relationalOperatorMatch);
    }

    Predicate<T> createPredicate(Operator operator, T domainObject) {
        return operator.getPredicateForValue(this.comparator, domainObject);
    }

    protected BooleanQuery generateRangeQueryForPredicate(String fieldName, Predicate<T> match) {
        Collection<T> domainObjects = this.resolver.getAll();
        BooleanQuery bq = new BooleanQuery();
        for (T indexedObject : CollectionUtil.filter(domainObjects, match)) {
            bq.add((Query)this.getTermQuery(fieldName, this.indexInfoResolver.getIndexedValue(indexedObject)), BooleanClause.Occur.SHOULD);
        }
        return bq;
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

