/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.link.RemoteIssueLink;

@PublicApi
public class RemoteIssueLinkBuilder {
    private Long id;
    private Long issueId;
    private String globalId;
    private String title;
    private String summary;
    private String url;
    private String iconUrl;
    private String iconTitle;
    private String relationship;
    private Boolean resolved;
    private String statusIconUrl;
    private String statusIconTitle;
    private String statusIconLink;
    private String applicationType;
    private String applicationName;

    public RemoteIssueLinkBuilder() {
    }

    public RemoteIssueLinkBuilder(RemoteIssueLink remoteIssueLink) {
        this.id(remoteIssueLink.getId());
        this.issueId(remoteIssueLink.getIssueId());
        this.globalId(remoteIssueLink.getGlobalId());
        this.title(remoteIssueLink.getTitle());
        this.summary(remoteIssueLink.getSummary());
        this.url(remoteIssueLink.getUrl());
        this.iconUrl(remoteIssueLink.getIconUrl());
        this.iconTitle(remoteIssueLink.getIconTitle());
        this.relationship(remoteIssueLink.getRelationship());
        this.resolved(remoteIssueLink.isResolved());
        this.statusIconUrl(remoteIssueLink.getStatusIconUrl());
        this.statusIconTitle(remoteIssueLink.getStatusIconTitle());
        this.statusIconLink(remoteIssueLink.getStatusIconLink());
        this.applicationType(remoteIssueLink.getApplicationType());
        this.applicationName(remoteIssueLink.getApplicationName());
    }

    public RemoteIssueLinkBuilder id(Long id) {
        this.id = id;
        return this;
    }

    public RemoteIssueLinkBuilder issueId(Long issueId) {
        this.issueId = issueId;
        return this;
    }

    public RemoteIssueLinkBuilder globalId(String globalId) {
        this.globalId = globalId;
        return this;
    }

    public RemoteIssueLinkBuilder title(String title) {
        this.title = title;
        return this;
    }

    public RemoteIssueLinkBuilder summary(String summary) {
        this.summary = summary;
        return this;
    }

    public RemoteIssueLinkBuilder url(String url) {
        this.url = url;
        return this;
    }

    public RemoteIssueLinkBuilder iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public RemoteIssueLinkBuilder iconTitle(String iconTitle) {
        this.iconTitle = iconTitle;
        return this;
    }

    public RemoteIssueLinkBuilder relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    public RemoteIssueLinkBuilder resolved(Boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    public RemoteIssueLinkBuilder statusIconUrl(String statusIconUrl) {
        this.statusIconUrl = statusIconUrl;
        return this;
    }

    public RemoteIssueLinkBuilder statusIconTitle(String statusIconTitle) {
        this.statusIconTitle = statusIconTitle;
        return this;
    }

    public RemoteIssueLinkBuilder statusIconLink(String statusIconLink) {
        this.statusIconLink = statusIconLink;
        return this;
    }

    public RemoteIssueLinkBuilder applicationType(String applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public RemoteIssueLinkBuilder applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public RemoteIssueLink build() {
        return new RemoteIssueLink(this.id, this.issueId, this.globalId, this.title, this.summary, this.url, this.iconUrl, this.iconTitle, this.relationship, this.resolved, this.statusIconUrl, this.statusIconTitle, this.statusIconLink, this.applicationType, this.applicationName);
    }
}

