/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import org.apache.commons.lang.StringUtils;

public class LookAndFeelBean {
    private final ApplicationProperties ap;

    private LookAndFeelBean(ApplicationProperties ap) {
        this.ap = ap;
    }

    public static LookAndFeelBean getInstance(ApplicationProperties ap) {
        return new LookAndFeelBean(ap);
    }

    private void incrementVersion() {
        long version = this.getVersion();
        this.ap.setString("jira.webresource.flushcounter", Long.toString(++version));
    }

    public String stripHash(String colour) {
        if (StringUtils.isNotBlank((String)colour) && colour.startsWith("#")) {
            return colour.substring(1, colour.length());
        }
        return colour;
    }

    private void setValue(String key, String value) {
        this.ap.setString(key, value);
        this.incrementVersion();
    }

    public void updateVersion(long oldVersion) {
        long currentVersion = this.getVersion();
        if (oldVersion > currentVersion) {
            this.ap.setString("jira.webresource.flushcounter", Long.toString(++oldVersion));
        } else {
            this.ap.setString("jira.webresource.flushcounter", Long.toString(++currentVersion));
        }
    }

    public long getVersion() {
        String editVersion = this.ap.getDefaultBackedString("jira.webresource.flushcounter");
        return Long.parseLong(StringUtils.isNotEmpty((String)editVersion) ? editVersion : "1");
    }

    public String getLogoUrl() {
        return this.ap.getDefaultBackedString("jira.lf.logo.url");
    }

    public String getAbsoluteLogoUrl() {
        String jiraLogo = this.getLogoUrl();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = ComponentAccessor.getComponent(WebResourceManager.class).getStaticResourcePrefix(UrlMode.AUTO) + jiraLogo;
        }
        return jiraLogo;
    }

    public void setLogoUrl(String logoUrl) {
        this.setValue("jira.lf.logo.url", logoUrl);
    }

    public String getLogoWidth() {
        return this.ap.getDefaultBackedString("jira.lf.logo.width");
    }

    public String getLogoPixelWidth() {
        return this.getLogoWidth() + "px";
    }

    public void setLogoWidth(String logoWidth) {
        this.setValue("jira.lf.logo.width", logoWidth);
    }

    public String getLogoHeight() {
        return this.ap.getDefaultBackedString("jira.lf.logo.height");
    }

    public String getLogoPixelHeight() {
        return this.getLogoHeight() + "px";
    }

    public void setLogoHeight(String logoHeight) {
        this.setValue("jira.lf.logo.height", logoHeight);
    }

    public String getFaviconUrl() {
        return this.ap.getDefaultBackedString("jira.lf.favicon.url");
    }

    public void setFaviconUrl(String faviconUrl) {
        this.setValue("jira.lf.favicon.url", faviconUrl);
    }

    public String getFaviconWidth() {
        return "16";
    }

    public String getFaviconHeight() {
        return "16";
    }

    public String getFaviconHiResUrl() {
        return this.ap.getDefaultBackedString("jira.lf.favicon.hires.url");
    }

    public void setFaviconHiResUrl(String faviconUrl) {
        this.setValue("jira.lf.favicon.hires.url", faviconUrl);
    }

    public String getFaviconHiResWidth() {
        return "32";
    }

    public String getFaviconHiResHeight() {
        return "32";
    }

    public String getTopBackgroundColour() {
        return this.getDefaultBackedString("jira.lf.top.bgcolour", "#003366");
    }

    public void setTopBackgroundColour(String topBackgroundColour) {
        this.setValue("jira.lf.top.bgcolour", topBackgroundColour);
    }

    public String getTopTxtColour() {
        return this.getDefaultBackedString("jira.lf.top.textcolour", "#ffffff");
    }

    public void setTopTxtColour(String topTxtColour) {
        this.setValue("jira.lf.top.textcolour", topTxtColour);
    }

    public String getTopHighlightColor() {
        return this.getDefaultBackedString("jira.lf.top.hilightcolour", "#326ca6");
    }

    public void setTopHighlightColor(String newValue) {
        this.setValue("jira.lf.top.hilightcolour", newValue);
    }

    public String getTopTextHighlightColor() {
        return this.getDefaultBackedString("jira.lf.top.texthilightcolour", "#f0f0f0");
    }

    public void setTopTextHighlightColor(String newValue) {
        this.setValue("jira.lf.top.texthilightcolour", newValue);
    }

    public String getTopSeparatorBackgroundColor() {
        return this.getDefaultBackedString("jira.lf.top.separator.bgcolor", "#003366");
    }

    public void setTopSeparatorBackgroundColor(String newValue) {
        this.setValue("jira.lf.top.separator.bgcolor", newValue);
    }

    public String getMenuTxtColour() {
        return this.getDefaultBackedString("jira.lf.menu.textcolour", "#ffffff");
    }

    public void setMenuTxtColour(String menuTxtColour) {
        this.setValue("jira.lf.menu.textcolour", menuTxtColour);
    }

    public String getMenuBackgroundColour() {
        return this.getDefaultBackedString("jira.lf.menu.bgcolour", "#326ca6");
    }

    public void setMenuBackgroundColour(String menuBackgroundColour) {
        this.setValue("jira.lf.menu.bgcolour", menuBackgroundColour);
    }

    public String getMenuSeparatorColour() {
        return this.getDefaultBackedString("jira.lf.menu.separator", "#f0f0f0");
    }

    public void setMenuSeparatorColour(String menuSeparatorColour) {
        this.setValue("jira.lf.menu.separator", menuSeparatorColour);
    }

    public String getTextHeadingColour() {
        return this.getDefaultBackedString("jira.lf.text.headingcolour", "#292929");
    }

    public void setTextHeadingColour(String textHeadingColour) {
        this.setValue("jira.lf.text.headingcolour", textHeadingColour);
    }

    public String getTextLinkColour() {
        return this.getDefaultBackedString("jira.lf.text.linkcolour", "#326ca6");
    }

    public void setTextLinkColour(String textLinkColour) {
        this.setValue("jira.lf.text.linkcolour", textLinkColour);
    }

    public String getTextActiveLinkColour() {
        return this.getDefaultBackedString("jira.lf.text.activelinkcolour", "#326ca6");
    }

    public void setTextActiveLinkColour(String textActiveLinkColour) {
        this.setValue("jira.lf.text.activelinkcolour", textActiveLinkColour);
    }

    public String getGadgetChromeColor(String id) {
        return this.ap.getDefaultBackedString("jira.lf.gadget." + id);
    }

    public void setGadgetChromeColor(String id, String gadgetChromeColor) {
        this.setValue("jira.lf.gadget." + id, gadgetChromeColor);
    }

    public String getApplicationID() {
        return this.ap.getDefaultBackedString("jira.lf.application.id");
    }

    public String getDefaultBackedString(String key, String defaultValue) {
        String value = this.ap.getDefaultBackedString(key);
        return value == null ? defaultValue : value;
    }

    public static class DefaultFaviconDimensions {
        public static final String FAVICON_DIMENSION = "16";
        public static final String FAVICON_HIRES_DIMENSION = "32";

        private DefaultFaviconDimensions() {
        }
    }

    public static final class DefaultColours {
        public static final String TOP_HIGHLIGHTCOLOUR = "#326ca6";
        public static final String TOP_TEXTHIGHLIGHTCOLOUR = "#f0f0f0";
        public static final String TOP_SEPARATOR_BGCOLOUR = "#003366";
        public static final String TOP_BGCOLOUR = "#003366";
        public static final String TOP_TEXTCOLOUR = "#ffffff";
        public static final String MENU_BGCOLOUR = "#326ca6";
        public static final String MENU_TEXTCOLOUR = "#ffffff";
        public static final String MENU_SEPARATOR = "#f0f0f0";
        public static final String TEXT_LINKCOLOR = "#326ca6";
        public static final String TEXT_ACTIVELINKCOLOR = "#326ca6";
        public static final String TEXT_HEADINGCOLOR = "#292929";

        private DefaultColours() {
        }
    }
}

