/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@Internal
public abstract class AbstractJiraContext
implements JiraContextNode {
    private static final Logger log = Logger.getLogger(AbstractJiraContext.class);

    @Override
    public boolean isInContext(IssueContext issueContext) {
        boolean matches = true;
        if (issueContext != null) {
            if (this.getProject() != null) {
                matches = this.getProject().equals((Object)issueContext.getProject());
            }
            if (this.getIssueTypeObject() != null) {
                matches = this.getIssueTypeObject().equals(issueContext.getIssueTypeObject());
            }
        } else {
            log.warn((Object)"The issue passed is null. Returning as a context match");
        }
        return matches;
    }

    public String toString() {
        GenericValue projectCategoryGV;
        IssueType issueType;
        StringBuilder sb = new StringBuilder();
        Project project = this.getProjectObject();
        if (project != null) {
            sb.append("Project: ").append(project.getName());
        }
        if ((issueType = this.getIssueTypeObject()) != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Issue type: ").append(issueType.getName());
        }
        if ((projectCategoryGV = this.getProjectCategory()) != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Project category: ").append(projectCategoryGV.getString("name"));
        }
        String description = sb.length() > 0 ? sb.toString() : "Global Context";
        return this.getClass().getSimpleName() + "[" + description + "]";
    }

    @Override
    public int compareTo(JiraContextNode o) {
        return new CompareToBuilder().append((Object)this.getProject(), (Object)o.getProject(), OfBizComparators.NAME_COMPARATOR).toComparison();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JiraContextNode)) {
            return false;
        }
        JiraContextNode rhs = (JiraContextNode)o;
        return new EqualsBuilder().append((Object)this.getProject(), (Object)rhs.getProject()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(77, 127).append((Object)this.getProject()).toHashCode();
    }
}

