/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@Internal
public class DefaultMessageHandlerContext
implements MessageHandlerContext {
    private final CommentManager commentManager;
    private final MessageHandlerExecutionMonitor monitor;
    private final IssueManager issueManager;
    private final AttachmentManager attachmentManager;

    public DefaultMessageHandlerContext(CommentManager commentManager, MessageHandlerExecutionMonitor monitor, IssueManager issueManager, AttachmentManager attachmentManager) {
        this.commentManager = commentManager;
        this.monitor = monitor;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public User createUser(String username, String password, String email, String fullname, Integer userEventType) throws PermissionException, CreateException {
        User user = userEventType == null ? ComponentAccessor.getUserUtil().createUserNoNotification(username, password, email, fullname) : ComponentAccessor.getUserUtil().createUserWithNotification(username, password, email, fullname, userEventType);
        this.monitor.info("Created user '" + user.getName() + ".");
        return user;
    }

    @Override
    public Comment createComment(Issue issue, User author, String body, boolean dispatchEvent) {
        Comment comment = this.commentManager.create(issue, author.getName(), body, dispatchEvent);
        this.monitor.info("Added comment '" + StringUtils.abbreviate((String)body, (int)20) + " 'by '" + author.getName() + "' to issue '" + issue.getKey() + "'");
        return comment;
    }

    @Override
    public Issue createIssue(@Nullable User reporter, Issue issue) throws CreateException {
        Issue issueObject = this.issueManager.createIssueObject(reporter, issue);
        this.monitor.info("Issue " + issueObject.getKey() + " created");
        return issueObject;
    }

    @Override
    public ChangeItemBean createAttachment(File file, String filename, String contentType, User author, Issue issue) throws AttachmentException {
        ChangeItemBean changeItemBean = this.attachmentManager.createAttachment(file, filename, contentType, author, issue);
        this.monitor.info("Added attachment to issue '" + issue.getKey() + "'");
        return changeItemBean;
    }

    @Override
    public boolean isRealRun() {
        return true;
    }

    @Override
    public MessageHandlerExecutionMonitor getMonitor() {
        return this.monitor;
    }
}

