/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.query.AbstractEqualityQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.TermQueryFactory;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.query.operator.Operator;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Query;

public class EqualityQueryFactory<T>
extends AbstractEqualityQueryFactory<T> {
    private static final Logger log = Logger.getLogger(EqualityQueryFactory.class);

    public EqualityQueryFactory(IndexInfoResolver<T> tIndexInfoResolver) {
        super(tIndexInfoResolver);
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery(fieldName));
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        log.warn((Object)String.format("Cannot create a query for an empty operand using the operator '%s'", operator.getDisplayString()));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    Query getIsEmptyQuery(String fieldName) {
        QueryFactoryResult result = new QueryFactoryResult(TermQueryFactory.nonEmptyQuery(fieldName), true);
        return QueryFactoryResult.wrapWithVisibilityQuery(fieldName, result).getLuceneQuery();
    }

    @Override
    Query getIsNotEmptyQuery(String fieldName) {
        return TermQueryFactory.nonEmptyQuery(fieldName);
    }
}

