/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.Date;

public final class DateRange {
    private final Date lowerDate;
    private final Date upperDate;

    public DateRange(Date lowerDate, Date upperDate) {
        Assertions.notNull("lowerDate", lowerDate);
        Assertions.notNull("upperDate", upperDate);
        this.lowerDate = this.minOf(lowerDate, upperDate);
        this.upperDate = this.maxOf(lowerDate, upperDate);
    }

    private Date maxOf(Date lowerDate, Date upperDate) {
        return lowerDate.getTime() > upperDate.getTime() ? lowerDate : upperDate;
    }

    private Date minOf(Date lowerDate, Date upperDate) {
        return lowerDate.getTime() <= upperDate.getTime() ? lowerDate : upperDate;
    }

    public Date getLowerDate() {
        return this.lowerDate;
    }

    public Date getUpperDate() {
        return this.upperDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)o;
        if (!this.lowerDate.equals(dateRange.lowerDate)) {
            return false;
        }
        return this.upperDate.equals(dateRange.upperDate);
    }

    public int hashCode() {
        int result = this.lowerDate.hashCode();
        result = 31 * result + this.upperDate.hashCode();
        return result;
    }
}

