/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class UserJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String emailAddress;
    @JsonProperty
    private Map<String, String> avatarUrls;
    @JsonProperty
    private String displayName;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private String timeZone;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public void setAvatarUrls(Map<String, String> avatarUrls) {
        this.avatarUrls = avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public static Collection<UserJsonBean> shortBeans(Collection<User> Users2, final JiraBaseUrls urls, final TimeZoneManager timeZoneManager) {
        return Lists.newArrayList((Iterable)Collections2.transform(Users2, (Function)new Function<User, UserJsonBean>(){

            public UserJsonBean apply(User from) {
                return UserJsonBean.shortBean(from, urls, timeZoneManager);
            }
        }));
    }

    public static UserJsonBean shortBean(User user, JiraBaseUrls urls, TimeZoneManager timeZoneManager) {
        if (user == null) {
            return null;
        }
        UserJsonBean bean = new UserJsonBean();
        bean.self = urls.restApi2BaseUrl() + "user/" + JiraUrlCodec.encode(user.getName());
        bean.id = user.getName();
        bean.name = user.getName();
        bean.displayName = user.getDisplayName();
        bean.emailAddress = user.getEmailAddress();
        bean.active = user.isActive();
        bean.avatarUrls = UserJsonBean.getAvatarURLs(user);
        bean.timeZone = timeZoneManager.getTimeZoneforUser(user).getDisplayName();
        return bean;
    }

    private static Map<String, String> getAvatarURLs(User user) {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        return MapBuilder.newBuilder().add("16x16", avatarService.getAvatarAbsoluteURL(user, user.getName(), Avatar.Size.SMALL).toString()).add("48x48", avatarService.getAvatarAbsoluteURL(user, user.getName(), Avatar.Size.LARGE).toString()).toMap();
    }
}

