/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.UserCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.MultiUserConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.notification.type.UserCFNotificationTypeAware;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class MultiUserCFType
extends AbstractMultiCFType<User>
implements UserCFNotificationTypeAware,
ProjectImportableCustomField,
UserField,
SortableCustomField<String> {
    protected final MultiUserConverter multiUserConverter;
    private ApplicationProperties applicationProperties;
    private JiraAuthenticationContext authenticationContext;
    private UserPickerSearchService searchService;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final UserCustomFieldImporter userCustomFieldImporter;

    public MultiUserCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, MultiUserConverter multiUserConverter, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, UserPickerSearchService searchService, FieldVisibilityManager fieldVisibilityManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.multiUserConverter = multiUserConverter;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.userCustomFieldImporter = new UserCustomFieldImporter();
    }

    @Override
    protected Comparator<User> getTypeComparator() {
        return new UserBestNameComparator(this.authenticationContext.getLocale());
    }

    @Override
    public Collection<User> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        HashSet userSet = new HashSet();
        Collection values = parameters.getValuesForNullKey();
        if (values == null || values.isEmpty()) {
            return null;
        }
        for (Object value : values) {
            userSet.addAll(this.convertDbObjectToTypes(new ArrayList<Object>(this.multiUserConverter.extractUserStringsFromString((String)value))));
        }
        ArrayList<User> l = new ArrayList<User>(userSet);
        Collections.sort(l, new UserBestNameComparator(this.authenticationContext.getLocale()));
        return l;
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection users = parameters.getValuesForNullKey();
        if (users == null || users.isEmpty()) {
            return null;
        }
        return this.putInvalidUsersAtFront(users);
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        StringBuffer errors = null;
        for (String singleParam : relevantParams.getValuesForNullKey()) {
            Collection<String> userStrings = this.multiUserConverter.extractUserStringsFromString(singleParam);
            if (userStrings == null) {
                return;
            }
            for (String user : userStrings) {
                try {
                    this.multiUserConverter.getUser(user);
                }
                catch (FieldValidationException e) {
                    if (errors == null) {
                        errors = new StringBuffer(user);
                    }
                    errors.append(", ").append(user);
                }
                if (errors == null) continue;
                errorCollectionToAddTo.addError(config.getCustomField().getId(), this.getI18nBean().getText("admin.errors.could.not.find.usernames", errors), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    @Override
    public String getStringFromSingularObject(User o) {
        return this.multiUserConverter.getString(o);
    }

    @Override
    public User getSingularObjectFromString(String s) throws FieldValidationException {
        return this.multiUserConverter.getUser(s);
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    @Override
    public List getRelatedIndexers(CustomField customField) {
        return EasyList.build((Object)new MultiUserCustomFieldIndexer(this.fieldVisibilityManager, customField, this.multiUserConverter));
    }

    @Override
    protected Object convertTypeToDbValue(User value) {
        return this.multiUserConverter.getString(value);
    }

    @Override
    protected User convertDbValueToType(Object string) {
        return this.multiUserConverter.getUser((String)string);
    }

    private Collection putInvalidUsersAtFront(Collection users) {
        HashSet<String> retSet = new HashSet<String>();
        StringBuffer errorString = null;
        if (users != null) {
            for (String userList : users) {
                for (String userString : this.multiUserConverter.extractUserStringsFromString(userList)) {
                    try {
                        this.multiUserConverter.getUser(userString);
                        retSet.add(userString);
                    }
                    catch (FieldValidationException e) {
                        if (errorString == null) {
                            errorString = new StringBuffer(userString);
                            continue;
                        }
                        errorString.append(", ").append(userString);
                    }
                }
            }
        }
        ArrayList<String> l = new ArrayList<String>(retSet);
        Collections.sort(l);
        if (errorString != null) {
            l.add(0, errorString.toString());
        }
        return l;
    }

    @Override
    @NotNull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.authenticationContext.getUser());
        boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch(ctx);
        if (canPerformAjaxSearch) {
            velocityParams.put("canPerformAjaxSearch", "true");
            velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:autocomplete");
        return velocityParams;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.userCustomFieldImporter;
    }

    @Override
    public int compare(@NotNull String customFieldObjectValue1, @NotNull String customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiUser(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiUser(MultiUserCFType var1);
    }

    static class MultiUserCustomFieldIndexer
    extends AbstractCustomFieldIndexer {
        private final CustomField customField;
        private final MultiUserConverter multiUserConverter;

        public MultiUserCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, MultiUserConverter multiUserConverter) {
            super(fieldVisibilityManager, customField);
            this.customField = customField;
            this.multiUserConverter = multiUserConverter;
        }

        @Override
        public void addDocumentFieldsSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
        }

        @Override
        public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NO);
        }

        public void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
            List o = (List)this.customField.getValue(issue);
            if (o != null) {
                for (User user : o) {
                    String userId = CaseFolding.foldUsername(this.multiUserConverter.getString(user));
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), userId, Field.Store.YES, indexType));
                }
            }
        }
    }
}

