/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.annotations.Internal;
import com.atlassian.configurable.ObjectConfigurable;
import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.services.mail.DelegatingMessageHandlerContext;
import com.atlassian.jira.service.services.mail.ErrorAccumulatingMessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.PortUtil;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.sun.mail.pop3.POP3Message;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

@Internal
public class MailFetcherService
extends AbstractMessageHandlingService
implements ObjectConfigurable {
    private static final Logger log = ComponentAccessor.getComponent(MailLoggingManager.class).getIncomingMailChildLogger("mailfetcherservice");
    private static final String OLD_MAIL_DISABLED_KEY = "atlassian.mail.popdisabled";
    private static final String MAIL_DISABLED_KEY = "atlassian.mail.fetchdisabled";
    public static final String KEY_MAIL_SERVER = "popserver";
    protected Long mailserverId = null;
    public static final String FORWARD_EMAIL = "forwardEmail";
    protected static final String DEFAULT_FOLDER = "INBOX";
    public static final String FOLDER_NAME_KEY = "foldername";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private final ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
    private final String baseUrl = this.applicationProperties.getString("jira.baseurl");
    private static final String ERROR_TEMPLATE = "errorinhandler.vm";
    private final ErrorEmailForwarder errorEmailForwarder;
    private final MessageProvider messageProvider;

    MailFetcherService(ErrorEmailForwarder errorEmailForwarder, MessageProvider messageProvider) {
        this.errorEmailForwarder = errorEmailForwarder;
        this.messageProvider = messageProvider;
    }

    public MailFetcherService() {
        this.errorEmailForwarder = new ErrorEmailForwarderImpl();
        this.messageProvider = new MessageProviderImpl();
    }

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(KEY_MAIL_SERVER)) {
            try {
                this.mailserverId = new Long(this.getProperty(KEY_MAIL_SERVER));
            }
            catch (Exception e) {
                log.error((Object)("Invalid mail server id: " + e), (Throwable)e);
            }
        }
    }

    protected int getPort(MailServer server) {
        int parsedPort = PortUtil.parsePort(server.getPort());
        if (parsedPort >= 0) {
            return parsedPort;
        }
        log.error((Object)("Invalid port number: " + server.getPort() + " for mail service: " + this.getName() + ". Using the default port for this service type."));
        return -1;
    }

    @Override
    protected void runImpl(MessageHandlerContext context) {
        log.debug((Object)(this.getClass().getSimpleName() + " run() method has been called"));
        if (this.isMailDisabled()) {
            context.getMonitor().error("Mail is disabled.");
            return;
        }
        final MessageHandler messageHandler = this.getHandler();
        if (messageHandler == null) {
            log.error((Object)"Message Handler is not configured propertly for this service. Exiting.");
            return;
        }
        MailServer mailserver = this.getMailServer(context.getMonitor());
        if (mailserver == null) {
            context.getMonitor().warning("no mail server returned from getMailServer(). Exiting run()");
            return;
        }
        this.messageProvider.getAndProcessMail(new MessageProvider.SingleMessageProcessor(){

            @Override
            public boolean process(Message message, MessageHandlerContext context) throws MessagingException, MailException {
                ErrorAccumulatingMessageHandlerExecutionMonitor accumulatingMonitor = new ErrorAccumulatingMessageHandlerExecutionMonitor(context.getMonitor());
                DelegatingMessageHandlerContext myMessageHandlerContext = new DelegatingMessageHandlerContext(context, accumulatingMonitor);
                log.debug((Object)"Calling handleMessage");
                boolean deleteThisMessage = messageHandler.handleMessage(message, myMessageHandlerContext);
                if (accumulatingMonitor.hasErrors() && MailFetcherService.this.forwardEmailParam() != null && !deleteThisMessage) {
                    String toAddress = MailFetcherService.this.forwardEmailParam();
                    log.debug((Object)("Forwarding error message to '" + toAddress + "'"));
                    deleteThisMessage = MailFetcherService.this.errorEmailForwarder.forwardEmail(message, myMessageHandlerContext, toAddress, accumulatingMonitor.getErrorsAsString(), accumulatingMonitor.getExceptionsAsString());
                }
                return deleteThisMessage;
            }
        }, mailserver, context);
    }

    private MailServer getMailServer(MessageHandlerExecutionMonitor monitor) {
        MailServer mailserver = null;
        if (this.mailserverId != null) {
            try {
                mailserver = MailFactory.getServerManager().getMailServer(new Long(this.getProperty(KEY_MAIL_SERVER)));
            }
            catch (Exception e) {
                monitor.error("Could not retrieve mail server: " + e, e);
            }
        } else {
            monitor.error(this.getClass().getName() + " cannot run without a configured Mail Server");
        }
        return mailserver;
    }

    boolean isMailDisabled() {
        if (Boolean.getBoolean(OLD_MAIL_DISABLED_KEY)) {
            log.info((Object)"Service disabled by 'atlassian.mail.popdisabled' property.");
            return true;
        }
        if (Boolean.getBoolean(MAIL_DISABLED_KEY)) {
            log.info((Object)"Service disabled by 'atlassian.mail.fetchdisabled' property.");
            return true;
        }
        return false;
    }

    protected String getFolderName(MailServer server) {
        if (server.getMailProtocol().equals((Object)MailProtocol.SECURE_IMAP) || server.getMailProtocol().equals((Object)MailProtocol.IMAP)) {
            try {
                return StringUtils.defaultString((String)this.getProperty(FOLDER_NAME_KEY), (String)DEFAULT_FOLDER);
            }
            catch (ObjectConfigurationException e) {
                throw new DataAccessException("Error retrieving foldername.", (Throwable)((Object)e));
            }
        }
        return DEFAULT_FOLDER;
    }

    private String forwardEmailParam() {
        try {
            return this.getProperty(FORWARD_EMAIL);
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException(this.addHandlerInfo("Error retrieving Forward Email flag."), (Throwable)((Object)e));
        }
    }

    @Override
    protected String addHandlerInfo(String msg) {
        return this.getName() + "[" + this.mailserverId + "]: " + msg;
    }

    private static I18nHelper getI18nHelper() {
        return ComponentAccessor.getI18nHelperFactory().getInstance((User)null);
    }

    @Override
    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("MAILFETCHERSERVICE", "services/com/atlassian/jira/service/services/mail/mailfetcherservice.xml", null);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    private class ErrorEmailForwarderImpl
    implements ErrorEmailForwarder {
        private ErrorEmailForwarderImpl() {
        }

        @Override
        public boolean forwardEmail(Message message, MessageHandlerContext context, String toAddress, String errorsAsString, String exceptionsAsString) throws MailException {
            if (TextUtils.verifyEmail((String)toAddress)) {
                try {
                    com.atlassian.jira.mail.Email email = this.createErrorForwardEmail(message, context.getMonitor(), toAddress, errorsAsString, exceptionsAsString);
                    this.sendMail(email, context, context.getMonitor());
                    return true;
                }
                catch (VelocityException e) {
                    context.getMonitor().error("Could not create email template for.", e);
                }
                catch (MessagingException e) {
                    context.getMonitor().error("Could not retrieve information from message.", e);
                }
            } else {
                context.getMonitor().warning("Forward Email is invalid.");
            }
            return false;
        }

        private void sendMail(com.atlassian.jira.mail.Email email, MessageHandlerContext context, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) throws MailException {
            SMTPMailServer mailserver = MailFactory.getServerManager().getDefaultSMTPMailServer();
            if (mailserver == null) {
                messageHandlerExecutionMonitor.warning("You do not currently have a smtp mail server set up yet.");
            } else if (MailFactory.isSendingDisabled()) {
                messageHandlerExecutionMonitor.warning("Sending mail is currently disabled in Jira.");
            } else {
                email.setFrom(mailserver.getDefaultFrom());
                if (context.isRealRun()) {
                    log.debug((Object)("Sending mail to [" + email.getTo() + "]"));
                    mailserver.send((Email)email);
                } else {
                    messageHandlerExecutionMonitor.info("Sending mail to '" + email.getTo() + "'");
                    log.debug((Object)("Sending mail to [" + email.getTo() + "] skipped due to dry-run mode"));
                }
            }
        }

        private com.atlassian.jira.mail.Email createErrorForwardEmail(Message message, MessageHandlerExecutionMonitor monitor, String toAddress, String errorsAsString, @Nullable String exceptionsAsString) throws VelocityException, MessagingException {
            com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(toAddress);
            email.setSubject(MailFetcherService.getI18nHelper().getText("template.errorinhandler.subject", message.getSubject()));
            HashMap<String, Object> contextParams = new HashMap<String, Object>();
            contextParams.putAll(this.getVelocityParams(errorsAsString, monitor));
            String body = ComponentAccessor.getVelocityManager().getEncodedBody(MailFetcherService.EMAIL_TEMPLATES, "text/errorinhandler.vm", MailFetcherService.this.baseUrl, MailFetcherService.this.applicationProperties.getString("webwork.i18n.encoding"), contextParams);
            email.setBody(body);
            MimeMultipart mp = new MimeMultipart();
            if (exceptionsAsString != null) {
                MimeBodyPart exception = new MimeBodyPart();
                exception.setContent((Object)exceptionsAsString, "text/plain");
                exception.setFileName("ErrorStackTrace.txt");
                mp.addBodyPart((BodyPart)exception);
            }
            MimeBodyPart messageAttachment = new MimeBodyPart();
            messageAttachment.setContent((Object)message, "message/rfc822");
            String subject = message.getSubject();
            if (StringUtils.isBlank((String)subject)) {
                subject = "NoSubject";
            }
            messageAttachment.setFileName(subject + ".eml");
            mp.addBodyPart((BodyPart)messageAttachment);
            email.setMultipart((Multipart)mp);
            return email;
        }

        private Map<String, Object> getVelocityParams(String error, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String handlerName = MailFetcherService.this.getHandler().getClass().toString();
            try {
                params.put("i18n", MailFetcherService.getI18nHelper());
                params.put("handlerName", handlerName);
                Long serverId = new Long(MailFetcherService.this.getProperty(MailFetcherService.KEY_MAIL_SERVER));
                params.put("serverName", MailFactory.getServerManager().getMailServer(serverId).getName());
                params.put("error", error);
                params.put("baseurl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
            }
            catch (ObjectConfigurationException e) {
                messageHandlerExecutionMonitor.error("Could not retrieve mail server", (Throwable)((Object)e));
            }
            catch (MailException e) {
                messageHandlerExecutionMonitor.error("Could not retrieve mail server", e);
            }
            return params;
        }
    }

    private class MessageProviderImpl
    implements MessageProvider {
        private MessageProviderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getAndProcessMail(MessageProvider.SingleMessageProcessor singleMessageProcessor, MailServer mailserver, MessageHandlerContext context) {
            Store store;
            Session session;
            log.debug((Object)("Using mail server [" + mailserver + "]"));
            String hostname = mailserver.getHostname();
            String username = mailserver.getUsername();
            String password = mailserver.getPassword();
            if (hostname == null || username == null || password == null) {
                context.getMonitor().warning("Cannot retrieve mail due to a missing parameter in Mail Server '" + mailserver.getName() + "': [host," + hostname + "],[username," + username + "],[password," + password + "]");
                return;
            }
            try {
                session = mailserver.getSession();
            }
            catch (Exception e) {
                context.getMonitor().error("Cannot create mail session: " + e.getMessage(), e);
                return;
            }
            String protocol = null;
            try {
                protocol = mailserver.getMailProtocol().getProtocol();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Getting store from the session using protocol [" + protocol + "]"));
                }
                store = session.getStore(protocol);
            }
            catch (NoSuchProviderException e) {
                context.getMonitor().error("Error getting provider for protocol " + protocol + ": " + (Object)((Object)e), e);
                return;
            }
            try {
                int port = MailFetcherService.this.getPort(mailserver);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Connecting to mail store to host [" + hostname + "] and port [" + port + "]"));
                }
                store.connect(hostname, port, username, password);
                log.debug((Object)"Successfully connected to mail store");
            }
            catch (MessagingException e) {
                context.getMonitor().error("Error connecting to host '" + hostname + "' as user '" + username + "' via protocol '" + protocol + "': " + (Object)((Object)e), e);
                return;
            }
            Folder folder = null;
            try {
                String folderName = MailFetcherService.this.getFolderName(mailserver);
                log.debug((Object)("Getting folder [" + folderName + "]"));
                folder = store.getFolder(folderName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got folder [" + folder + "], now opening it for read/write"));
                }
                folder.open(!context.isRealRun() ? 1 : 2);
                Message[] messages = folder.getMessages();
                log.debug((Object)MailFetcherService.this.addHandlerInfo("Found " + messages.length + " message(s) in the " + protocol + " folder"));
                if (!context.isRealRun()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Found ");
                    sb.append(messages.length);
                    sb.append(" message(s) in the ");
                    sb.append(protocol);
                    sb.append(" folder.");
                    if (messages.length > 10) {
                        sb.append(" Only first 10 messages will be processed in test mode.");
                    }
                    context.getMonitor().info(sb.toString());
                }
                context.getMonitor().setNumMessages(messages.length);
                int messagesLength = messages.length;
                for (int i = 0; i < messagesLength; ++i) {
                    Message message = messages[i];
                    context.getMonitor().nextMessage(message);
                    if (!context.isRealRun() && i >= 10) {
                        log.debug((Object)"In dry-run mode only first 10 messages are processed. Skipping the rest");
                        break;
                    }
                    log.debug((Object)"Processing message");
                    boolean deleteThisMessage = false;
                    String msgId = null;
                    try {
                        String string = msgId = message.getHeader("Message-ID") != null ? message.getHeader("Message-ID")[0] : "null";
                        if (log.isDebugEnabled()) {
                            try {
                                log.debug((Object)("Message Subject: " + message.getSubject()));
                                log.debug((Object)("Message-ID: " + msgId));
                            }
                            catch (MessagingException e) {
                                context.getMonitor().warning("Messaging exception thrown on getting message subject. Message may have corrupt headers.", e);
                            }
                        }
                        deleteThisMessage = singleMessageProcessor.process(message, context);
                        continue;
                    }
                    catch (Exception e) {
                        context.getMonitor().error("Exception: " + e.getLocalizedMessage(), e);
                        continue;
                    }
                    finally {
                        if (message != null) {
                            if (message instanceof POP3Message) {
                                ((POP3Message)message).invalidate(true);
                            }
                            if (deleteThisMessage) {
                                if (context.isRealRun()) {
                                    log.debug((Object)("Deleting Message: " + msgId));
                                    message.setFlag(Flags.Flag.DELETED, true);
                                } else {
                                    context.getMonitor().info("Deleting Message '" + message.getSubject() + "'");
                                    log.debug((Object)("Deleting Message: " + msgId + " (skipped due to dry-run mode)"));
                                }
                            }
                        }
                    }
                }
            }
            catch (MessagingException e) {
                context.getMonitor().error("Messaging Exception in service '" + this.getClass().getName() + "' when getting mail: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (folder != null) {
                        log.debug((Object)"Closing folder");
                        folder.close(true);
                    }
                    log.debug((Object)"Closing store");
                    store.close();
                }
                catch (Exception e) {
                    log.debug((Object)MailFetcherService.this.addHandlerInfo("Error whilst closing folder and store: " + e.getMessage()));
                }
            }
        }
    }

    static interface ErrorEmailForwarder {
        public boolean forwardEmail(Message var1, MessageHandlerContext var2, String var3, String var4, String var5) throws MailException;
    }

    static interface MessageProvider {
        public void getAndProcessMail(SingleMessageProcessor var1, MailServer var2, MessageHandlerContext var3);

        public static interface SingleMessageProcessor {
            public boolean process(Message var1, MessageHandlerContext var2) throws MessagingException, MailException;
        }
    }
}

