/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.ofbiz.core.entity.GenericValue;

public class IssueContextImpl
implements IssueContext,
Comparable {
    private Long projectId;
    private String issueTypeId;

    public IssueContextImpl(@Nullable Long projectId, @Nullable String issueTypeId) {
        this.projectId = projectId;
        this.issueTypeId = issueTypeId;
    }

    public IssueContextImpl(@Nullable Project project, @Nullable IssueType issueType) {
        this.projectId = project != null ? project.getId() : null;
        this.issueTypeId = issueType != null ? issueType.getId() : null;
    }

    @Override
    public Project getProjectObject() {
        return this.getProjectManager().getProjectObj(this.projectId);
    }

    @Override
    public GenericValue getProject() {
        return this.getProjectManager().getProject(this.projectId);
    }

    private ProjectManager getProjectManager() {
        return ComponentAccessor.getComponent(ProjectManager.class);
    }

    @Override
    public GenericValue getIssueType() {
        return this.getConstantsManager().getIssueType(this.issueTypeId);
    }

    @Override
    public IssueType getIssueTypeObject() {
        return this.getConstantsManager().getIssueTypeObject(this.issueTypeId);
    }

    ConstantsManager getConstantsManager() {
        return ComponentAccessor.getComponent(ConstantsManager.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueContextImpl that = (IssueContextImpl)o;
        if (this.issueTypeId != null ? !this.issueTypeId.equals(that.issueTypeId) : that.issueTypeId != null) {
            return false;
        }
        return !(this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null);
    }

    public int hashCode() {
        int result = this.projectId != null ? this.projectId.hashCode() : 0;
        result = 29 * result + (this.issueTypeId != null ? this.issueTypeId.hashCode() : 0);
        return result;
    }

    public int compareTo(Object obj) {
        IssueContextImpl o = (IssueContextImpl)obj;
        return new CompareToBuilder().append((Object)this.projectId, (Object)o.projectId).append((Object)this.issueTypeId, (Object)o.issueTypeId).toComparison();
    }
}

