/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class IssueLinkBeanBuilder {
    private final ApplicationProperties applicationProperties;
    private final IssueLinkManager issueLinkManager;
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final Issue issue;

    public IssueLinkBeanBuilder(ApplicationProperties applicationProperties, IssueLinkManager issueLinkManager, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, Issue issue) {
        this.applicationProperties = applicationProperties;
        this.issueLinkManager = issueLinkManager;
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issue = issue;
    }

    public List<IssueLinkJsonBean> buildIssueLinks() {
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            return null;
        }
        ArrayList linkBeans = Lists.newArrayList();
        LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(this.issue, this.authContext.getLoggedInUser());
        Set<IssueLinkType> linkTypes = linkCollection.getLinkTypes();
        if (linkTypes != null) {
            for (IssueLinkType issueLinkType : linkTypes) {
                List<Issue> inwardIssues;
                List<Issue> outwardIssues = linkCollection.getOutwardIssues(issueLinkType.getName());
                if (outwardIssues != null) {
                    for (Issue issue : outwardIssues) {
                        linkBeans.add(this.buildLink(issueLinkType, issue, true));
                    }
                }
                if ((inwardIssues = linkCollection.getInwardIssues(issueLinkType.getName())) == null) continue;
                for (Issue issue : inwardIssues) {
                    linkBeans.add(this.buildLink(issueLinkType, issue, false));
                }
            }
        }
        return linkBeans;
    }

    private IssueLinkJsonBean buildLink(IssueLinkType issueLinkType, Issue issue, boolean isOutbound) {
        URI linkTypeURI = URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "issueLinkType/" + issueLinkType.getId());
        IssueLinkJsonBean issueLink = new IssueLinkJsonBean().type(IssueLinkTypeJsonBean.create(issueLinkType, linkTypeURI));
        return isOutbound ? issueLink.outwardIssue(this.createIssueLink(issue)) : issueLink.inwardIssue(this.createIssueLink(issue));
    }

    public IssueLinkJsonBean buildParentLink() {
        Issue parent = this.issue.getParentObject();
        if (parent == null) {
            return null;
        }
        return new IssueLinkJsonBean().type(new IssueLinkTypeJsonBean().name("Parent")).inwardIssue(this.createIssueLink(parent));
    }

    public List<IssueLinkJsonBean> buildSubtaskLinks() {
        Collection<Issue> subtasks = this.issue.getSubTaskObjects();
        if (subtasks == null) {
            return Collections.emptyList();
        }
        ArrayList subtaskLinks = Lists.newArrayListWithCapacity((int)subtasks.size());
        for (Issue subtask : subtasks) {
            subtaskLinks.add(new IssueLinkJsonBean().type(new IssueLinkTypeJsonBean().name("Sub-Task")).outwardIssue(this.createIssueLink(subtask)));
        }
        return subtaskLinks;
    }

    private IssueRefJsonBean createIssueLink(Issue issue) {
        return new IssueRefJsonBean().id(String.valueOf(issue.getId())).key(issue.getKey()).self(URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "issue/" + issue.getId())).fields(new IssueRefJsonBean.Fields().summary(issue.getSummary()).status(StatusJsonBean.shortBean(issue.getStatusObject(), this.jiraBaseUrls)).issueType(IssueTypeJsonBean.shortBean(issue.getIssueTypeObject(), this.jiraBaseUrls)).priority(PriorityJsonBean.shortBean(issue.getPriorityObject(), this.jiraBaseUrls)));
    }
}

