/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.converters.UserConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractSingleValueCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.NavigatorConversionResult;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.UserFitsNavigatorHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.Collections;

public class UserPickerCustomFieldSearchInputTransformer
extends AbstractSingleValueCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final UserConverter userConverter;
    private final UserFitsNavigatorHelper userFitsNavigatorHelper;

    public UserPickerCustomFieldSearchInputTransformer(String urlParameterName, ClauseNames clauseNames, CustomField field, UserConverter userConverter, UserFitsNavigatorHelper userFitsNavigatorHelper, CustomFieldInputHelper customFieldInputHelper) {
        super(field, clauseNames, urlParameterName, customFieldInputHelper);
        this.userFitsNavigatorHelper = Assertions.notNull("userFitsNavigatorHelper", userFitsNavigatorHelper);
        this.userConverter = Assertions.notNull("userConverter", userConverter);
    }

    @Override
    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        CustomFieldParams custParams = (CustomFieldParams)fieldValuesHolder.get(this.getCustomField().getId());
        if (custParams == null) {
            return;
        }
        String user = (String)custParams.getFirstValueForNullKey();
        try {
            this.userConverter.getUser(user);
        }
        catch (FieldValidationException e) {
            errors.addError(this.getCustomField().getId(), i18nHelper.getText("admin.errors.could.not.find.username", user));
        }
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        NavigatorConversionResult result = this.convertForNavigator(query);
        if (!result.fitsNavigator()) {
            return false;
        }
        if (result.getValue() == null) {
            return true;
        }
        SingleValueOperand value = result.getValue();
        String user = value.getStringValue() == null ? value.getLongValue().toString() : value.getStringValue();
        return this.userFitsNavigatorHelper.checkUser(user) != null;
    }

    @Override
    protected CustomFieldParams getParamsFromSearchRequest(User searcher, Query query, SearchContext searchContext) {
        SingleValueOperand value;
        String userValue;
        String userName;
        NavigatorConversionResult result = this.convertForNavigator(query);
        if (result.fitsNavigator() && result.getValue() != null && (userName = this.userFitsNavigatorHelper.checkUser(userValue = (value = result.getValue()).getStringValue() == null ? value.getLongValue().toString() : value.getStringValue())) != null) {
            return new CustomFieldParamsImpl(this.getCustomField(), Collections.singleton(userName));
        }
        return null;
    }
}

