/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;

public class TextCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<String> {
    public TextCustomFieldOperationsHandler(CustomField field) {
        super(field);
    }

    @Override
    protected String getInitialValue(Issue issue, ErrorCollection errors) {
        return (String)this.field.getValue(issue);
    }

    @Override
    protected String getInitialCreateValue(IssueContext issueCtx) {
        FieldConfig config = this.field.getRelevantConfig(issueCtx);
        return (String)this.field.getCustomFieldType().getDefaultValue(config);
    }

    @Override
    protected String handleSetOperation(IssueContext issueCtx, Issue issue, String currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (!operationValue.isString()) {
            errors.addError(this.field.getId(), "Operation value must be a string", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return operationValue.asString();
    }

    @Override
    protected void finaliseOperation(String finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), finalValue);
    }
}

