/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCustomFieldOperationsHandler<T>
implements RestFieldOperationsHandler {
    protected final CustomField field;

    public AbstractCustomFieldOperationsHandler(CustomField field) {
        this.field = field;
    }

    @Override
    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.SET.getName());
    }

    protected abstract T getInitialValue(Issue var1, ErrorCollection var2);

    protected abstract T getInitialCreateValue(IssueContext var1);

    protected abstract void finaliseOperation(T var1, IssueInputParameters var2, ErrorCollection var3);

    @Override
    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        T newFieldValue;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        T t = newFieldValue = issue == null ? this.getInitialCreateValue(issueCtx) : this.getInitialValue(issue, errors);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        for (FieldOperationHolder operation : operations) {
            String oper = operation.getOperation();
            JsonData operationValue = operation.getData();
            try {
                StandardOperation standardOperation = StandardOperation.valueOf(oper.toUpperCase());
                switch (standardOperation) {
                    case ADD: {
                        newFieldValue = this.handleAddOperation(issueCtx, issue, newFieldValue, operationValue, errors);
                        break;
                    }
                    case SET: {
                        newFieldValue = this.handleSetOperation(issueCtx, issue, newFieldValue, operationValue, errors);
                        break;
                    }
                    case REMOVE: {
                        newFieldValue = this.handleRemoveOperation(issueCtx, issue, newFieldValue, operationValue, errors);
                        break;
                    }
                    default: {
                        newFieldValue = this.applyOperation(issueCtx, issue, standardOperation, newFieldValue, operationValue, errors);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                errors.addErrorMessage("No operation with name '" + oper + "' found. Valid operations are '" + StringUtils.join((Object[])StandardOperation.values(), (String)","));
            }
        }
        if (errors.hasAnyErrors()) {
            return errors;
        }
        this.finaliseOperation(newFieldValue, inputParameters, errors);
        return errors;
    }

    protected T handleSetOperation(IssueContext issueCtx, Issue issue, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException("Remove operation not supported!");
    }

    protected T handleRemoveOperation(IssueContext issueCtx, Issue issue, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException("Remove operation not supported!");
    }

    protected T handleAddOperation(IssueContext issueCtx, Issue issue, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException("Add operation not supported!");
    }

    protected T applyOperation(IssueContext issueCtx, Issue issue, StandardOperation operation, T currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        throw new UnsupportedOperationException("'" + operation.getName() + "' operation not supported!");
    }
}

