package com.atlassian.jira.template.soy;

import java.util.Map;

/**
 * Provides methods for rending Closure (Soy) templates on the server.
 *
 * @since v5.0
 */
public interface SoyTemplateRenderer
{
    /**
     * Render a single template with the supplied data.
     *
     * @param templateName name of the soy template to render
     * @param data a string keyed map of data to render the template with
     *
     * @return the rendered template string
     */
    String render(String completeModuleKey, String templateName, Map<String, Object> data) throws SoyException;

}
