package com.atlassian.jira.service.util.handler;


import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * An ancient class which used to handle errors from mail handlers. Now MailHandlerExecutionMonitor is used instead
 * and everyone is welcome to provide their own implementation. This naive implementation is still used by unit tests.
 */
public class NaiveMailHandlerExecutionMonitor implements MailHandlerExecutionMonitor
{
    private String errorMessage;
    private String exception;

    public NaiveMailHandlerExecutionMonitor()
    {
        errorMessage = null;
        exception = null;
    }

    public boolean hasErrors()
    {
        return errorMessage != null || exception != null;
    }

    public String getErrorsAsString()
    {
        return errorMessage;
    }

    public String getExceptionsAsString()
    {
        return exception;
    }

    public void addError(String errorMessage)
    {
        this.errorMessage = errorMessage;
    }

    @Override
    public void messageRejected(String reason)
    {
    }

    public void addError(String errorMessage, Exception exception)
    {
        this.errorMessage = errorMessage;

//        StringBuffer exceptionString = new StringBuffer();
//
//        if (exception != null)
//        {
//            StackTraceElement[] stackTrace = exception.getStackTrace();
//            exceptionString.append(exception.toString() + "\n");
//
//            for (int i = 0; i < stackTrace.length; i++)
//            {
//                exceptionString.append("\t" + stackTrace[i].toString() + "\n");
//            }
//
//            Throwable cause = exception.getCause();
//            while (true)
//            {
//                if (cause == null)
//                    break;
//                StackTraceElement[] causeStackTrace = cause.getStackTrace();
//                exceptionString.append("Caused by: " + cause.toString() + "\n");
//                for (int i = 0; i < causeStackTrace.length; i++)
//                {
//                    exceptionString.append("\t" + causeStackTrace[i].toString() + "\n");
//                }
//                cause = cause.getCause();
//            }
//        }

        StringWriter stringWriter = new StringWriter();
        PrintWriter p = new PrintWriter(stringWriter);
        exception.printStackTrace(p);
        p.flush();
        this.exception = stringWriter.toString();
    }

    @Override
    public void addInfo(String info)
    {
    }

    @Override
    public void addWarning(String warning)
    {
    }

    public void reset()
    {
        errorMessage = null;
        exception = null;
    }

    public String getError()
    {
        return getErrorsAsString();
    }

    @Override
    public void setNumMessages(int count)
    {
    }

    @Override
    public void elementCreated(Element element)
    {
    }
}
