package com.atlassian.jira.service.util.handler;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.google.common.collect.Maps;
import org.apache.log4j.Logger;

import java.util.Map;

/**
 * TODO: Document this class / interface here
 *
 * @since v5.0
 */
public class DryRunEntityCreationHandler implements EntityCreationHandler
{
    private final Map<String, User> dummyUsersById = Maps.newHashMap();
    private final MailHandlerExecutionMonitor mailHandlerExecutionMonitor;

    public DryRunEntityCreationHandler(MailHandlerExecutionMonitor mailHandlerExecutionMonitor) {
        this.mailHandlerExecutionMonitor = mailHandlerExecutionMonitor;
    }

    @Override
    public User createUserWithNotification(String username, String password, String email, String fullname, int userEventType)
            throws PermissionException, CreateException
    {
        return createUserNoNotification(username, password, email, fullname);

    }

    @Override
    public User createUserNoNotification(String username, String password, String emailAddress, String displayName)
            throws PermissionException, CreateException
    {
        User user = dummyUsersById.get(username);
        if (user == null) {
            mailHandlerExecutionMonitor.addInfo("Creating user '" + username + "'");
            mailHandlerExecutionMonitor.elementCreated(MailHandlerExecutionMonitor.Element.USER);
            user = new ImmutableUser(-1, username, displayName, emailAddress, true);
            dummyUsersById.put(username, user);
        }
        return user;
    }

    @Override
    public boolean isReal()
    {
        return false;
    }
}
