package com.atlassian.jira.issue.fields.rest.json.beans;

import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * This bean holds the information that is reported for each issue link.
 *
 * @since v4.2
 */
@JsonSerialize
@XmlRootElement (name = "issueLinks")
public class IssueLinkJsonBean
{
    @XmlElement (name = "type")
    private IssueLinkTypeJsonBean type;

    @JsonProperty
    private IssueRefJsonBean inwardIssue;

    @JsonProperty
    private IssueRefJsonBean outwardIssue;

    public IssueLinkJsonBean()
    {
    }

    public IssueLinkJsonBean(IssueLinkTypeJsonBean type, IssueRefJsonBean inwardIssue, IssueRefJsonBean outwardIssue)
    {
        this.type = type;
        this.inwardIssue = inwardIssue;
        this.outwardIssue = outwardIssue;
    }

    public IssueLinkTypeJsonBean type()
    {
        return this.type;
    }

    public IssueLinkJsonBean type(IssueLinkTypeJsonBean type)
    {
        return new IssueLinkJsonBean(type, inwardIssue,  outwardIssue);
    }

    public IssueRefJsonBean inwardIssue()
    {
        return this.inwardIssue;
    }

    public IssueLinkJsonBean inwardIssue(IssueRefJsonBean inwardIssue)
    {
        return new IssueLinkJsonBean(type, inwardIssue,  outwardIssue);
    }

    public IssueRefJsonBean outwardIssue()
    {
        return this.outwardIssue;
    }

    public IssueLinkJsonBean outwardIssue(IssueRefJsonBean outwardIssue)
    {
        return new IssueLinkJsonBean(type, inwardIssue,  outwardIssue);
    }
}
