package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;

/**
 * Basic operation handler for single value Text Fields.
 *
 * @since v5.0
 */
public class TextCustomFieldOperationsHandler extends AbstractCustomFieldOperationsHandler<String>
{
    public TextCustomFieldOperationsHandler(CustomField field)
    {
        super(field);
    }

    /**
     * compute the "currentValue" to be passed to applyOperation()
     */
    protected String getInitialValue(Issue issue, ErrorCollection errors)
    {
        return (String) field.getValue(issue);
    }

    /**
     * compute the "currentValue" to be passed to applyOperation()
     * @param issueCtx
     */
    protected String getInitialCreateValue(IssueContext issueCtx)
    {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        return (String) field.getCustomFieldType().getDefaultValue(config);
    }

    @Override
    protected String handleSetOperation(IssueContext issueCtx, Issue issue, String currentFieldValue, JsonData operationValue, ErrorCollection errors)
    {
        if (!operationValue.isString())
        {
            errors.addError(field.getId(), "Operation value must be a string", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return operationValue.asString();
    }

    /**
     * takes the value returnd by a call to applyOperation() and puts it into the inputparams
     */
    protected void finaliseOperation(String finalValue, IssueInputParameters parameters, ErrorCollection errors)
    {
        parameters.addCustomFieldValue(field.getId(), finalValue);
    }

}
