package com.atlassian.jira.event.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;

import java.util.Collections;
import java.util.Set;

/**
 * When a user mentions another user on an issue via the @username or [~username] syntax this event will be fired. It
 * contains the user that added the comment or description, all users mentioned, the issue as well as the text in which
 * the mentions occurred. Finally it also contains the fieldId of the field in which users were mentioned.
 *
 * @since v5.0
 */
@PublicApi
public class MentionIssueEvent
{
    private final Issue issue;
    private final User fromUser;
    private final Set<User> toUsers;
    private final String mentionText;
    private final String fieldId;

    public MentionIssueEvent(Issue issue, User fromUser, Set<User> toUsers, String mentionText, String fieldId)
    {
        this.issue = issue;
        this.fromUser = fromUser;
        this.toUsers = toUsers;
        this.mentionText = mentionText;
        this.fieldId = fieldId;
    }

    public Issue getIssue()
    {
        return issue;
    }

    public User getFromUser()
    {
        return fromUser;
    }

    public Set<User> getToUsers()
    {
        return Collections.unmodifiableSet(toUsers);
    }

    public String getMentionText()
    {
        return mentionText;
    }

    public String getFieldId()
    {
        return fieldId;
    }
}
