/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CommentJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private UserJsonBean author;
    @JsonProperty
    private String body;
    @JsonProperty
    private UserJsonBean updateAuthor;
    @JsonProperty
    @XmlJavaTypeAdapter(value=Dates.DateTimeAdapter.class)
    private Date created;
    @JsonProperty
    @XmlJavaTypeAdapter(value=Dates.DateTimeAdapter.class)
    private Date updated;
    @JsonProperty
    private VisibilityBean visibility;
    @JsonIgnore
    private boolean isVisibilitySet = false;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public void setAuthor(UserJsonBean author) {
        this.author = author;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public UserJsonBean getUpdateAuthor() {
        return this.updateAuthor;
    }

    public void setUpdateAuthor(UserJsonBean updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @JsonIgnore
    public boolean isVisibilitySet() {
        return this.isVisibilitySet;
    }

    @JsonProperty
    public VisibilityBean getVisibility() {
        return this.visibility;
    }

    @JsonProperty
    public void setVisibility(VisibilityBean visibility) {
        this.visibility = visibility;
        this.isVisibilitySet = true;
    }

    public static Collection<CommentJsonBean> shortBeans(Collection<Comment> Comments, final JiraBaseUrls urls, final ProjectRoleManager projectRoleManager) {
        return Lists.newArrayList((Iterable)Collections2.transform(Comments, (Function)new Function<Comment, CommentJsonBean>(){

            public CommentJsonBean apply(Comment from) {
                return CommentJsonBean.shortBean(from, urls, projectRoleManager);
            }
        }));
    }

    public static CommentJsonBean shortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager) {
        if (comment == null) {
            return null;
        }
        CommentJsonBean bean = new CommentJsonBean();
        bean.self = urls.restApi2BaseUrl() + "comment/" + JiraUrlCodec.encode(comment.getId().toString());
        bean.id = comment.getId().toString();
        bean.body = comment.getBody();
        bean.author = UserJsonBean.shortBean(comment.getAuthorUser(), urls);
        bean.created = comment.getCreated();
        bean.updateAuthor = UserJsonBean.shortBean(comment.getUpdateAuthorUser(), urls);
        bean.updated = comment.getUpdated();
        bean.visibility = CommentJsonBean.getVisibilityBean(comment, projectRoleManager);
        return bean;
    }

    private static VisibilityBean getVisibilityBean(Comment comment, ProjectRoleManager projectRoleManager) {
        VisibilityBean visibilityBean = null;
        String groupLevel = comment.getGroupLevel();
        if (groupLevel != null) {
            visibilityBean = new VisibilityBean(VisibilityType.group, groupLevel);
        } else {
            Long roleId = comment.getRoleLevelId();
            if (roleId != null) {
                String roleName = projectRoleManager.getProjectRole(roleId).getName();
                visibilityBean = new VisibilityBean(VisibilityType.role, roleName);
            }
        }
        return visibilityBean;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class VisibilityBean {
        @JsonProperty
        public VisibilityType type;
        @JsonProperty
        public String value;

        public VisibilityBean() {
        }

        public VisibilityBean(VisibilityType type, String value) {
            this.type = type;
            this.value = value;
        }

        public VisibilityType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum VisibilityType {
        group,
        role;

    }
}

