/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.user.UserUtils;
import java.util.Collection;

public class UserFitsNavigatorHelper {
    private final UserPickerSearchService userPickerSearchService;

    public UserFitsNavigatorHelper(UserPickerSearchService userPickerSearchService) {
        this.userPickerSearchService = userPickerSearchService;
    }

    public String checkUser(String name) {
        String user = this.findUserName(name);
        if (user != null) {
            return user;
        }
        if (this.isFullNameAndEmailSearchingEnabled() && this.userExistsByFullNameOrEmail(name)) {
            return null;
        }
        return name;
    }

    public boolean isFullNameAndEmailSearchingEnabled() {
        return this.userPickerSearchService.isAjaxSearchEnabled();
    }

    String findUserName(String name) {
        User user = UserUtils.getUser(name.toLowerCase());
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    boolean userExistsByFullNameOrEmail(String name) {
        Collection<User> users = UserUtils.getAllUsers();
        for (User u : users) {
            String fullName = u.getDisplayName();
            String email = u.getEmailAddress();
            if (fullName != null && fullName.equalsIgnoreCase(name)) {
                return true;
            }
            if (email == null || !email.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

