/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.jira.issue.link.RemoteLink;
import com.atlassian.jira.issue.link.RemoteLinkImpl;

public class RemoteLinkBuilder {
    private Long id;
    private Long issueId;
    private String remoteId;
    private String urlLabel;
    private String description;
    private String url;
    private String iconUrl;
    private String relationship;
    private String applicationType;
    private String applicationName;

    public RemoteLinkBuilder() {
    }

    public RemoteLinkBuilder(RemoteLink remoteLink) {
        this.id(remoteLink.getId());
        this.issueId(remoteLink.getIssueId());
        this.remoteId(remoteLink.getRemoteId());
        this.urlLabel(remoteLink.getUrlLabel());
        this.description(remoteLink.getDescription());
        this.url(remoteLink.getUrl());
        this.iconUrl(remoteLink.getIconUrl());
        this.relationship(remoteLink.getRelationship());
        this.applicationType(remoteLink.getApplicationType());
        this.applicationName(remoteLink.getApplicationName());
    }

    public RemoteLinkBuilder id(Long id) {
        this.id = id;
        return this;
    }

    public RemoteLinkBuilder issueId(Long issueId) {
        this.issueId = issueId;
        return this;
    }

    public RemoteLinkBuilder remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    public RemoteLinkBuilder urlLabel(String urlLabel) {
        this.urlLabel = urlLabel;
        return this;
    }

    public RemoteLinkBuilder description(String description) {
        this.description = description;
        return this;
    }

    public RemoteLinkBuilder url(String url) {
        this.url = url;
        return this;
    }

    public RemoteLinkBuilder iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public RemoteLinkBuilder relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    public RemoteLinkBuilder applicationType(String applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public RemoteLinkBuilder applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public RemoteLink build() {
        return new RemoteLinkImpl(this.id, this.issueId, this.remoteId, this.urlLabel, this.description, this.url, this.iconUrl, this.relationship, this.applicationType, this.applicationName);
    }
}

