/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestUtils;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import java.util.Comparator;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractCustomFieldStatisticsMapper
implements StatisticsMapper {
    protected final CustomField customField;

    public AbstractCustomFieldStatisticsMapper(CustomField customField) {
        this.customField = customField;
    }

    @Override
    public String getDocumentConstant() {
        return this.customField.getId();
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        if (value != null) {
            SearchService searchService = ComponentAccessor.getComponent(SearchService.class);
            User user = ComponentAccessor.getJiraAuthenticationContext().getUser();
            SearchContext searchRequestContext = searchService.getSearchContext(user, searchRequest.getQuery());
            SearchContext possibleContext = this.getSearchContextFromValue(value);
            SearchContext combinedSearchContext = SearchRequestUtils.getCombinedSearchContext(searchRequestContext, possibleContext);
            CustomFieldSearcher searcher = this.customField.getCustomFieldSearcher();
            if (searcher.getSearchRenderer().isShown(user, combinedSearchContext)) {
                List<String> issueTypeIds;
                JqlClauseBuilder whereClauseBuilder = JqlQueryBuilder.newClauseBuilder(searchRequest.getQuery()).defaultAnd();
                List<Long> projectIds = combinedSearchContext.getProjectIds();
                if (projectIds != null && !projectIds.isEmpty()) {
                    whereClauseBuilder.project().inNumbers(projectIds);
                }
                if ((issueTypeIds = combinedSearchContext.getIssueTypeIds()) != null && !issueTypeIds.isEmpty()) {
                    whereClauseBuilder.issueType().inStrings(issueTypeIds);
                }
                whereClauseBuilder.addStringCondition(JqlCustomFieldId.toString(this.customField.getIdAsLong()), this.getSearchValue(value));
                return new SearchRequest(whereClauseBuilder.buildQuery());
            }
            return null;
        }
        return null;
    }

    protected SearchContext getSearchContextFromValue(Object value) {
        List<GenericValue> associatedIssueTypes;
        List<Long> projectIds = null;
        List<String> issueTypeIds = null;
        List<GenericValue> associatedProjects = this.customField.getAssociatedProjects();
        if (associatedProjects != null && !associatedProjects.isEmpty() && associatedProjects.get(0) != null) {
            projectIds = GenericValueUtils.transformToLongIdsList(associatedProjects);
        }
        if ((associatedIssueTypes = this.customField.getAssociatedIssueTypes()) != null && !associatedIssueTypes.isEmpty() && associatedIssueTypes.get(0) != null) {
            issueTypeIds = GenericValueUtils.transformToStringIdsList(associatedIssueTypes);
        }
        SearchContextFactory searchContextFactory = ComponentAccessor.getComponent(SearchContextFactory.class);
        return searchContextFactory.create(null, projectIds, issueTypeIds);
    }

    protected abstract String getSearchValue(Object var1);

    @Override
    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return ((String)o1).compareTo((String)o2);
            }
        };
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCustomFieldStatisticsMapper that = (AbstractCustomFieldStatisticsMapper)o;
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        return this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
    }
}

