/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.ProjectPickerCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.ProjectOptionsConfigItem;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.option.GenericImmutableOptions;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCFType
extends AbstractSingleFieldType<GenericValue>
implements MultipleCustomFieldType<GenericValue, GenericValue>,
SortableCustomField<GenericValue>,
ProjectImportableCustomField {
    private final Logger log = Logger.getLogger(ProjectCFType.class);
    private final ProjectConverter projectConverter;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;

    public ProjectCFType(CustomFieldValuePersister customFieldValuePersister, ProjectConverter projectConverter, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.projectConverter = projectConverter;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectCustomFieldImporter = new ProjectPickerCustomFieldImporter();
    }

    @Override
    public int compare(GenericValue customFieldObjectValue1, GenericValue customFieldObjectValue2, FieldConfig fieldConfig) {
        return OfBizComparators.NAME_COMPARATOR.compare(customFieldObjectValue1, customFieldObjectValue2);
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DECIMAL;
    }

    @Override
    protected Object getDbValueFromObject(GenericValue customFieldObject) {
        if (customFieldObject == null) {
            return null;
        }
        return new Double(customFieldObject.getLong("id").longValue());
    }

    @Override
    protected GenericValue getObjectFromDbValue(@NotNull Object databaseValue) throws FieldValidationException {
        Double projectId = (Double)databaseValue;
        return this.projectConverter.getProject(new Long(projectId.intValue()));
    }

    @Override
    public String getStringFromSingularObject(GenericValue customFieldObject) {
        return this.projectConverter.getString(customFieldObject);
    }

    @Override
    public GenericValue getSingularObjectFromString(String string) throws FieldValidationException {
        return this.projectConverter.getProject(string);
    }

    @Override
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List<FieldConfigItemType> configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new ProjectOptionsConfigItem(this.projectConverter, this.permissionManager, this.jiraAuthenticationContext));
        return configurationItemTypes;
    }

    @Override
    public Options getOptions(FieldConfig config, JiraContextNode jiraContextNode) {
        try {
            ArrayList<GenericValue> originalList = new ArrayList<GenericValue>(this.permissionManager.getProjects(10, this.jiraAuthenticationContext.getLoggedInUser()));
            return new GenericImmutableOptions(originalList, config);
        }
        catch (UnsupportedOperationException e) {
            this.log.error((Object)"Unable to retreive projects. Likely to be an issue with SubvertedPermissionManager. Please restart to resolve the problem.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getChangelogString(CustomField field, GenericValue value) {
        if (value == null) {
            return null;
        }
        return value.getString("name");
    }

    @Override
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        GenericValue project;
        Map<String, Object> params = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null && (project = (GenericValue)this.getValueFromIssue(field, issue)) != null) {
            boolean hasPermission = this.permissionManager.hasPermission(10, project, this.jiraAuthenticationContext.getLoggedInUser());
            params.put("isProjectVisible", hasPermission ? Boolean.TRUE : Boolean.FALSE);
        }
        return params;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitProject(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitProject(ProjectCFType var1);
    }
}

