/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.imports.project.customfield.NoTransformationCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.DatePickerConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.history.DateTimeFieldChangeLogHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NotNull;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DateTimeCFType
extends AbstractSingleFieldType<Date>
implements SortableCustomField<Date>,
ProjectImportableCustomField,
DateField {
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private final DateTimeFormatter datePickerFormatter;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApplicationProperties applicationProperties;
    private final DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper;

    public DateTimeCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, DateTimeFormatterFactory dateTimeFormatterFactory, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, DateTimeFieldChangeLogHelper dateTimeFieldChangeLogHelper) {
        super(customFieldValuePersister, genericConfigManager);
        this.applicationProperties = applicationProperties;
        this.dateTimeFieldChangeLogHelper = dateTimeFieldChangeLogHelper;
        this.projectCustomFieldImporter = new NoTransformationCustomFieldImporter();
        this.datePickerFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_TIME_PICKER);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public DateTimeCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, DateTimeFormatterFactory dateTimeFormatterFactory, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties) {
        this(customFieldValuePersister, genericConfigManager, dateTimeFormatterFactory, jiraAuthenticationContext, applicationProperties, ComponentAccessor.getComponentOfType(DateTimeFieldChangeLogHelper.class));
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DATE;
    }

    @Override
    protected Object getDbValueFromObject(Date customFieldObject) {
        return customFieldObject;
    }

    @Override
    protected Date getObjectFromDbValue(@NotNull Object databaseValue) throws FieldValidationException {
        return (Date)databaseValue;
    }

    @Override
    public String getStringFromSingularObject(Date customFieldObject) {
        return this.datePickerFormatter.format(customFieldObject);
    }

    @Override
    public String getChangelogString(CustomField field, Date value) {
        if (value == null) {
            return "";
        }
        return this.getStringFromSingularObject(value);
    }

    @Override
    public String getChangelogValue(CustomField field, Date value) {
        if (value == null) {
            return "";
        }
        return this.dateTimeFieldChangeLogHelper.createChangelogValueForDateTimeField(value);
    }

    @Override
    public Date getSingularObjectFromString(String string) throws FieldValidationException {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            Date date = this.datePickerFormatter.parse(string);
            return new Timestamp(date.getTime());
        }
        catch (IllegalArgumentException e) {
            I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
            throw new FieldValidationException(i18nBean.getText("fields.validation.data.format", this.applicationProperties.getDefaultBackedString("jira.date.time.picker.java.format")));
        }
    }

    @Override
    public int compare(Date v1, Date v2, FieldConfig fieldConfig) {
        return v1.compareTo(v2);
    }

    @Override
    public Date getDefaultValue(FieldConfig fieldConfig) {
        Date defaultValue = (Date)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (this.isUseNow(defaultValue)) {
            defaultValue = new Timestamp(new Date().getTime());
        }
        return defaultValue;
    }

    public boolean isUseNow(Date date) {
        return DatePickerConverter.USE_NOW_DATE.equals(date);
    }

    public boolean isUseNow(FieldConfig fieldConfig) {
        Date defaultValue = (Date)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        return this.isUseNow(defaultValue);
    }

    public String getNow() {
        return this.datePickerFormatter.format(new Date());
    }

    @Override
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> map = super.getVelocityParameters(issue, field, fieldLayoutItem);
        map.put("dateTimePicker", Boolean.TRUE);
        map.put("datePickerFormatter", this.datePickerFormatter);
        map.put("titleFormatter", this.datePickerFormatter.withStyle(DateTimeStyle.COMPLETE));
        map.put("iso8601Formatter", this.datePickerFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME));
        return map;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitDateTime(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitDateTime(DateTimeCFType var1);
    }
}

