/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@PublicSpi
public interface AvatarManager {
    public static final String AVATAR_IMAGE_FORMAT = "PNG";
    public static final String USER_AVATAR_ID_KEY = "user.avatar.id";

    public Avatar getById(Long var1) throws DataAccessException;

    public boolean delete(Long var1) throws DataAccessException;

    public boolean delete(Long var1, boolean var2);

    public void update(Avatar var1) throws DataAccessException;

    @NotNull
    public Avatar create(Avatar var1) throws DataAccessException;

    @NotNull
    public Avatar create(Avatar var1, InputStream var2, Selection var3) throws DataAccessException, IOException;

    @NotNull
    public List<Avatar> getAllSystemAvatars(Avatar.Type var1) throws DataAccessException;

    @NotNull
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type var1, String var2) throws DataAccessException;

    public boolean isAvatarOwner(Avatar var1, String var2);

    public void readAvatarData(Avatar var1, ImageSize var2, Consumer<InputStream> var3) throws IOException;

    @NotNull
    public File getAvatarBaseDirectory();

    @NotNull
    public Long getDefaultAvatarId(Avatar.Type var1);

    public Long getAnonymousAvatarId();

    public boolean hasPermissionToView(User var1, Avatar.Type var2, String var3);

    public boolean hasPermissionToEdit(User var1, Avatar.Type var2, String var3);

    public static enum ImageSize {
        LARGE(48, ""),
        MEDIUM(32, "medium_"),
        SMALL(16, "small_");

        private final int pixels;
        private final String filenameFlag;
        private final Selection originSelection;
        private static final ImageSize largest;

        private ImageSize(int pixels, String filenameFlag) {
            this.pixels = pixels;
            this.filenameFlag = Assertions.notNull("filenameFlag", filenameFlag);
            this.originSelection = new Selection(0, 0, pixels, pixels);
        }

        public int getPixels() {
            return this.pixels;
        }

        public String getFilenameFlag() {
            return this.filenameFlag;
        }

        public Selection getOriginSelection() {
            return this.originSelection;
        }

        public static ImageSize largest() {
            return largest;
        }

        public static ImageSize fromString(String text) {
            for (ImageSize value : ImageSize.values()) {
                if (!StringUtils.startsWithIgnoreCase((String)value.name(), (String)text)) continue;
                return value;
            }
            return ImageSize.largest();
        }

        static {
            ImageSize maxValue = SMALL;
            for (ImageSize imageSize : ImageSize.values()) {
                if (imageSize.getPixels() <= maxValue.getPixels()) continue;
                maxValue = imageSize;
            }
            largest = maxValue;
        }
    }
}

