/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SimpleNavigatorCollectorVisitor
implements ClauseVisitor<Void> {
    private final List<TerminalClause> clauses = new ArrayList<TerminalClause>();
    private final Set<String> clauseNames;
    protected boolean valid = true;
    protected boolean validPath = true;

    public SimpleNavigatorCollectorVisitor(String clauseName) {
        this(Collections.singleton(Assertions.notBlank("clauseName", clauseName)));
    }

    public SimpleNavigatorCollectorVisitor(Set<String> clauseNames) {
        Assertions.containsNoNulls("clauseNames", clauseNames);
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (clauseNames != null) {
            names.addAll(clauseNames);
        }
        this.clauseNames = Collections.unmodifiableSet(names);
    }

    public SimpleNavigatorCollectorVisitor(ClauseNames clauseNames) {
        this(Assertions.notNull("clauseNames", clauseNames).getJqlFieldNames());
    }

    public List<TerminalClause> getClauses() {
        return this.clauses;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Void visit(AndClause andClause) {
        for (Clause clause : andClause.getClauses()) {
            clause.accept(this);
        }
        return null;
    }

    @Override
    public Void visit(NotClause notClause) {
        boolean oldValidPath = this.validPath;
        this.validPath = false;
        notClause.getSubClause().accept(this);
        this.validPath = oldValidPath;
        return null;
    }

    @Override
    public Void visit(OrClause orClause) {
        boolean oldValidPath = this.validPath;
        this.validPath = false;
        for (Clause clause : orClause.getClauses()) {
            clause.accept(this);
        }
        this.validPath = oldValidPath;
        return null;
    }

    @Override
    public Void visit(TerminalClause terminalClause) {
        if (this.matches(terminalClause)) {
            this.clauses.add(terminalClause);
            if (!this.validPath) {
                this.valid = false;
            }
        }
        return null;
    }

    @Override
    public Void visit(WasClause clause) {
        return null;
    }

    private boolean matches(TerminalClause terminalClause) {
        return this.clauseNames.contains(terminalClause.getName());
    }
}

