/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.DateCustomFieldSearchRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.LocalDateIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.RelativeDateSearcherInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.statistics.LocalDateFieldSorter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.LocalDateClauseQueryFactory;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.jql.validator.LocalDateValidator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.query.operator.Operator;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class DateRangeSearcher
extends AbstractInitializationCustomFieldSearcher
implements SortableCustomFieldSearcher,
CustomFieldSearcher {
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private final JqlOperandResolver operandResolver;
    private final JqlLocalDateSupport jqlLocalDateSupport;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final VelocityRequestContextFactory velocityRenderContext;
    private final ApplicationProperties applicationProperties;
    private final VelocityManager velocityManager;
    private final CalendarLanguageUtil calendarUtils;
    private final FieldVisibilityManager fieldVisibilityManager;

    public DateRangeSearcher(JqlOperandResolver operandResolver, JqlLocalDateSupport jqlLocalDateSupport, CustomFieldInputHelper customFieldInputHelper, DateTimeFormatterFactory dateTimeFormatterFactory, VelocityRequestContextFactory velocityRenderContext, ApplicationProperties applicationProperties, VelocityManager velocityManager, CalendarLanguageUtil calendarUtils, FieldVisibilityManager fieldVisibilityManager) {
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.jqlLocalDateSupport = Assertions.notNull("jqlLocalDateSupport", jqlLocalDateSupport);
        this.velocityRenderContext = Assertions.notNull("velocityRenderContext", velocityRenderContext);
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        this.velocityManager = Assertions.notNull("velocityManager", velocityManager);
        this.calendarUtils = Assertions.notNull("calendarUtils", calendarUtils);
        this.fieldVisibilityManager = Assertions.notNull("fieldVisibilityManager", fieldVisibilityManager);
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
        this.dateTimeFormatterFactory = Assertions.notNull("dateTimeFormatterFactory", dateTimeFormatterFactory);
    }

    @Override
    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        Set<Operator> supportedOperators = OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY;
        SimpleFieldSearchConstants constants = new SimpleFieldSearchConstants(field.getId(), names, field.getId(), field.getId(), field.getId(), supportedOperators, JiraDataTypes.DATE);
        LocalDateIndexer indexer = new LocalDateIndexer(this.fieldVisibilityManager, field);
        String nameKey = "navigator.filter." + field.getId();
        DateSearcherConfig config = new DateSearcherConfig(field.getId(), names, field.getName());
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchInputTransformer = new RelativeDateSearcherInputTransformer(config, this.operandResolver, this.jqlLocalDateSupport, this.customFieldInputHelper, this.dateTimeFormatterFactory);
        this.searchRenderer = this.createSearchRenderer(field, constants, nameKey, config);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldSearcherClauseHandler(new LocalDateValidator(this.operandResolver, this.jqlLocalDateSupport), new LocalDateClauseQueryFactory(constants, this.jqlLocalDateSupport, this.operandResolver), supportedOperators, JiraDataTypes.DATE);
    }

    DateCustomFieldSearchRenderer createSearchRenderer(CustomField field, SimpleFieldSearchConstants constants, String nameKey, DateSearcherConfig config) {
        return new DateCustomFieldSearchRenderer(false, field, constants, config, this.velocityRenderContext, this.applicationProperties, this.velocityManager, this.calendarUtils, this.fieldVisibilityManager);
    }

    @Override
    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    @Override
    public LuceneFieldSorter getSorter(CustomField customField) {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve Sorter off uninitialised custom field searcher.");
        }
        return new LocalDateFieldSorter(this.searcherInformation.getId());
    }

    @Override
    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }
}

