/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.manager;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.project.ProjectManager;

public class JiraContextTreeManager {
    private JiraContextNode rootNode;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;

    public JiraContextTreeManager(ProjectManager projectManager, ConstantsManager constantsManager) {
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
    }

    public JiraContextNode getRootNode() {
        if (this.rootNode == null) {
            this.recreateRootNode();
        }
        return this.rootNode;
    }

    public void refresh() {
        this.rootNode = null;
    }

    private void recreateRootNode() {
        this.rootNode = new GlobalIssueContext(this);
    }

    public static JiraContextNode getRootContext() {
        return new GlobalIssueContext(new JiraContextTreeManager(ComponentAccessor.getProjectManager(), ComponentAccessor.getConstantsManager()));
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }
}

