/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.jira.issue.context.AbstractJiraContext;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCategoryContext
extends AbstractJiraContext {
    protected GenericValue projectCategory;
    private List<JiraContextNode> children;
    private final JiraContextTreeManager treeManager;

    public ProjectCategoryContext(GenericValue projectCategory, JiraContextTreeManager treeManager) {
        this.projectCategory = projectCategory;
        this.treeManager = treeManager;
    }

    public BandanaContext getParentContext() {
        return GlobalIssueContext.getInstance();
    }

    public boolean hasParentContext() {
        return true;
    }

    @Override
    public List<JiraContextNode> getChildContexts() {
        GenericValue projectCategory;
        Collection<GenericValue> projects;
        if (this.children == null && (projects = (projectCategory = this.getProjectCategory()) != null ? this.treeManager.getProjectManager().getProjectsFromProjectCategory(projectCategory) : this.treeManager.getProjectManager().getProjectsWithNoCategory()) != null) {
            this.children = new ArrayList<JiraContextNode>(projects.size());
            for (GenericValue gv : projects) {
                this.children.add(new ProjectContext(gv, this.treeManager));
            }
        }
        return this.children;
    }

    @Override
    public Map<String, Object> appendToParamsMap(Map<String, Object> input) {
        return MapBuilder.newBuilder(input).add("projectcategory", this.getProjectCategory() != null ? this.getProjectCategory().getLong("id") : null).add("project", null).toMap();
    }

    @Override
    public Project getProjectObject() {
        return null;
    }

    @Override
    public GenericValue getProject() {
        return null;
    }

    @Override
    public GenericValue getProjectCategory() {
        return this.projectCategory;
    }

    @Override
    public IssueType getIssueTypeObject() {
        return null;
    }

    @Override
    public GenericValue getIssueType() {
        return null;
    }
}

