/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.SelectCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiSettableCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class MultiSelectCFType
extends AbstractMultiSettableCFType
implements MultipleSettableCustomFieldType,
MultipleCustomFieldType,
SortableCustomField<List<String>>,
GroupSelectorField,
ProjectImportableCustomField {
    public static final String COMMA_REPLACEMENT = "&#44;";
    private static final Logger log = Logger.getLogger(MultiSelectCFType.class);
    private final ProjectCustomFieldImporter projectCustomFieldImporter = new SelectCustomFieldImporter();

    public MultiSelectCFType(OptionsManager optionsManager, CustomFieldValuePersister valuePersister, GenericConfigManager genericConfigManager) {
        super(optionsManager, valuePersister, genericConfigManager);
    }

    @Override
    public Set<Long> getIssueIdsWithValue(CustomField field, Option option) {
        if (option != null) {
            return this.customFieldValuePersister.getIssueIdsWithValue(field, PersistenceFieldType.TYPE_LIMITED_TEXT, option.getOptionId().toString());
        }
        return Collections.emptySet();
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Object value) {
        Collection values = (Collection)value;
        ArrayList<Long> defaultIds = new ArrayList<Long>();
        if (values != null) {
            for (Option o : values) {
                defaultIds.add(o.getOptionId());
            }
        }
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), defaultIds);
    }

    @Override
    public Object getDefaultValue(FieldConfig fieldConfig) {
        ArrayList<Option> options = new ArrayList<Option>();
        Collection optionIds = (Collection)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (optionIds != null) {
            for (Long optionId : optionIds) {
                Option option = this.optionsManager.findByOptionId(optionId);
                if (option == null) continue;
                options.add(option);
            }
        }
        return options;
    }

    @Override
    public Object getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        Collection values = parameters.getAllValues();
        if (CustomFieldUtils.isCollectionNotEmpty(values)) {
            ArrayList<Object> options = new ArrayList<Object>();
            for (Object value : values) {
                options.add(this.getSingularObjectFromString((String)value));
            }
            return options;
        }
        return null;
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getValuesForNullKey();
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Collection params = relevantParams.getAllValues();
        if (params == null || params.isEmpty()) {
            return;
        }
        CustomField customField = config.getCustomField();
        for (String paramValue : params) {
            if ("-1".equals(paramValue)) {
                if (params.size() <= 1) continue;
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.cannot.specify.none"));
                continue;
            }
            Options options = this.optionsManager.getOptions(config);
            Long optionId = null;
            try {
                optionId = Long.valueOf(paramValue);
            }
            catch (NumberFormatException e) {
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + paramValue + "'", "'" + customField + "'", options.getRootOptions().toString()));
            }
            if (options.getOptionById(optionId) != null) continue;
            errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + paramValue + "'", "'" + customField + "'", options.getRootOptions().toString()));
        }
    }

    @Override
    public void createValue(CustomField customField, Issue issue, Object value) {
        Collection<?> objects = this.getValueCollectionFromObjects(value);
        this.customFieldValuePersister.createValues(customField, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT, objects);
    }

    @Override
    public void updateValue(CustomField customField, Issue issue, Object value) {
        Collection<?> objects = this.getValueCollectionFromObjects(value);
        this.customFieldValuePersister.updateValues(customField, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT, objects);
    }

    @Override
    public void removeValue(CustomField field, Issue issue, Option option) {
        if (option != null) {
            this.customFieldValuePersister.removeValue(field, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT, option.getOptionId().toString());
        }
    }

    private Collection<?> getValueCollectionFromObjects(Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<String> stringCollection = new ArrayList<String>();
        for (Option option : (Collection)value) {
            stringCollection.add(this.getStringFromSingularObject(option));
        }
        return stringCollection;
    }

    @Override
    public Object getValueFromIssue(CustomField field, Issue issue) {
        List values = this.customFieldValuePersister.getValues(field, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT);
        if (values == null || values.isEmpty()) {
            return null;
        }
        ArrayList<Object> options = new ArrayList<Object>();
        for (Object value : values) {
            options.add(this.getSingularObjectFromString((String)value));
        }
        return options;
    }

    @Override
    public String getChangelogValue(CustomField field, Object value) {
        if (value != null) {
            ArrayList<String> stringValues = new ArrayList<String>();
            ArrayList array = (ArrayList)value;
            for (Option option : array) {
                stringValues.add(option.getOptionId().toString());
            }
            return StringUtils.join(stringValues, (String)",");
        }
        return "";
    }

    @Override
    public String getChangelogString(CustomField field, Object value) {
        ArrayList<String> stringValues = new ArrayList<String>();
        if (value != null) {
            ArrayList array = (ArrayList)value;
            for (Option option : array) {
                stringValues.add(option.getValue());
            }
            return StringUtils.join(stringValues, (String)",");
        }
        return "";
    }

    @Override
    public Object getSingularObjectFromString(String string) throws FieldValidationException {
        if ("-1".equals(string)) {
            return null;
        }
        return this.getOptionFromStringValue(string);
    }

    private Option getOptionFromStringValue(String selectValue) throws FieldValidationException {
        Long aLong = OptionUtils.safeParseLong(selectValue);
        if (aLong != null) {
            Option option = this.optionsManager.findByOptionId(aLong);
            if (option != null) {
                return option;
            }
            return null;
        }
        return null;
    }

    @Override
    public String getStringFromSingularObject(Object optionObject) {
        if (optionObject == null) {
            return null;
        }
        if (optionObject instanceof Option) {
            Option option = (Option)optionObject;
            return option.getOptionId().toString();
        }
        log.warn((Object)("Object passed '" + optionObject + "' is not an Option but " + optionObject != null ? " of type " + optionObject.getClass() : " is null"));
        return null;
    }

    @Override
    public List<FieldConfigItemType> getConfigurationItemTypes() {
        List<FieldConfigItemType> configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new SettableOptionsConfigItem(this, this.optionsManager));
        return configurationItemTypes;
    }

    @Override
    public int compare(List<String> customFieldObjectValue1, List<String> customFieldObjectValue2, FieldConfig fieldConfig) {
        Options options = this.getOptions(fieldConfig, null);
        if (options != null) {
            Long i1 = this.getLowestIndex(customFieldObjectValue1, options);
            Long i2 = this.getLowestIndex(customFieldObjectValue2, options);
            return i1.compareTo(i2);
        }
        log.info((Object)"No options were found.");
        return 0;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    private Long getLowestIndex(List<String> l, Options options) {
        Long lowest = new Long(Long.MAX_VALUE);
        for (String name : l) {
            Option o = options.getOptionById(Long.valueOf(name));
            if (o == null || o.getSequence() == null || o.getSequence().compareTo(lowest) >= 0) continue;
            lowest = o.getSequence();
        }
        return lowest;
    }

    public static Collection<String> extractTransferObjectFromString(String value) {
        String[] a;
        if (value == null) {
            return null;
        }
        ArrayList<String> valuesToAdd = new ArrayList<String>();
        for (String s : a = StringUtils.split((String)StringUtils.replace((String)value, (String)"\\,", (String)COMMA_REPLACEMENT), (String)",")) {
            String s2 = StringUtils.replace((String)s, (String)COMMA_REPLACEMENT, (String)",");
            String s3 = StringUtils.trimToNull((String)s2);
            if (s3 == null) continue;
            valuesToAdd.add(s3);
        }
        return valuesToAdd;
    }

    public static String getStringFromTransferObject(Collection<String> collection) {
        if (collection != null) {
            StringBuffer sb = new StringBuffer();
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                s = StringUtils.replace((String)s, (String)",", (String)"\\,");
                sb.append(s);
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public boolean valuesEqual(Object v1, Object v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1 instanceof Collection && v2 instanceof Collection) {
            return CollectionUtils.isEqualCollection((Collection)((Collection)v1), (Collection)((Collection)v2));
        }
        log.error((Object)("Unexpected value types for MultiSelectCFType. v1 = '" + v1 + "' v2 = '" + v2 + "'."));
        return v1.equals(v2);
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiSelect(this);
        }
        return super.accept(visitor);
    }

    @Override
    public Query getQueryForGroup(String fieldName, String groupName) {
        return new TermQuery(new Term(fieldName + "_raw", groupName));
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiSelect(MultiSelectCFType var1);
    }
}

