/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.converters.StringConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.TextCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractMultiCFType<T>
extends TextCFType
implements CustomFieldType {
    public AbstractMultiCFType(CustomFieldValuePersister customFieldValuePersister, StringConverter stringConverter, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, stringConverter, genericConfigManager);
    }

    protected abstract Comparator<T> getTypeComparator();

    protected abstract String convertTypeToString(Object var1);

    protected abstract T convertStringToType(String var1);

    @Override
    public Object getDefaultValue(FieldConfig fieldConfig) {
        Object o = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            return this.convertStringsToTypes((Collection)o);
        }
        throw new IllegalArgumentException("Value: " + o + " must be a collection. Type not allowed: " + o.getClass());
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Object value) {
        Collection<String> names = this.convertTypesToStringsIfRequired((Collection)value);
        if (names == null || names.isEmpty()) {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), null);
        } else {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), names);
        }
    }

    @Override
    public void createValue(CustomField customField, Issue issue, Object value) {
        this.customFieldValuePersister.createValues(customField, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT, this.convertTypesToStringsIfRequired((Collection)value));
    }

    @Override
    public void updateValue(CustomField customField, Issue issue, Object value) {
        this.customFieldValuePersister.updateValues(customField, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT, this.convertTypesToStringsIfRequired((Collection)value));
    }

    @Override
    public Object getValueFromIssue(CustomField field, Issue issue) {
        List textValues = this.customFieldValuePersister.getValues(field, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT);
        return textValues == null || textValues.isEmpty() ? null : this.convertStringsToTypes(textValues);
    }

    @Override
    public String getChangelogValue(CustomField field, Object value) {
        return value == null ? "" : value.toString();
    }

    protected final Collection<String> convertTypesToStringsIfRequired(Collection<?> typedList) {
        if (typedList == null) {
            return null;
        }
        return CollectionUtil.transform(typedList, new Function<Object, String>(){

            @Override
            public String get(Object item) {
                if (item instanceof String) {
                    return (String)item;
                }
                return AbstractMultiCFType.this.convertTypeToString(item);
            }
        });
    }

    protected final Collection<T> convertStringsToTypes(Collection<String> strings) {
        if (strings == null) {
            return null;
        }
        HashSet<T> retSet = new HashSet<T>();
        for (String element : strings) {
            String string = element.trim();
            try {
                T value = this.convertStringToType(string);
                if (value == null) continue;
                retSet.add(value);
            }
            catch (FieldValidationException ignore) {}
        }
        ArrayList list = new ArrayList(retSet);
        Collections.sort(list, this.getTypeComparator());
        return list;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiField(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiField(AbstractMultiCFType var1);
    }
}

