/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

public class LocalDate
implements Comparable<LocalDate> {
    private final int year;
    private final int month;
    private final int day;

    public LocalDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String toString() {
        return this.year + "-" + this.month + "-" + this.day;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDate localDate = (LocalDate)o;
        if (this.day != localDate.day) {
            return false;
        }
        if (this.month != localDate.month) {
            return false;
        }
        return this.year == localDate.year;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.day;
        return result;
    }

    @Override
    public int compareTo(LocalDate localDate) {
        if (this.year < localDate.year) {
            return -1;
        }
        if (this.year > localDate.year) {
            return 1;
        }
        if (this.month < localDate.month) {
            return -1;
        }
        if (this.month > localDate.month) {
            return 1;
        }
        if (this.day < localDate.day) {
            return -1;
        }
        if (this.day > localDate.day) {
            return 1;
        }
        return 0;
    }
}

