/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.comparator.ConstantsComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.query.operator.Operator;
import com.opensymphony.util.TextUtils;
import java.util.Comparator;

public abstract class AbstractConstantStatisticsMapper
implements StatisticsMapper<IssueConstant> {
    protected final ConstantsManager constantsManager;

    protected AbstractConstantStatisticsMapper(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    @Override
    public abstract String getDocumentConstant();

    protected abstract String getConstantType();

    protected abstract String getIssueFieldConstant();

    @Override
    public Comparator<IssueConstant> getComparator() {
        return ConstantsComparator.COMPARATOR;
    }

    @Override
    public boolean isValidValue(IssueConstant value) {
        return true;
    }

    @Override
    public IssueConstant getValueFromLuceneField(String documentValue) {
        if (TextUtils.stringSet((String)documentValue)) {
            return this.constantsManager.getConstantObject(this.getConstantType(), documentValue);
        }
        return null;
    }

    @Override
    public SearchRequest getSearchUrlSuffix(IssueConstant value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder(searchRequest.getQuery());
        if (value != null) {
            String searchValue = value.getName();
            queryBuilder.where().defaultAnd().addStringCondition(this.getIssueFieldConstant(), Operator.EQUALS, searchValue);
        } else {
            queryBuilder.where().defaultAnd().addEmptyCondition(this.getIssueFieldConstant());
        }
        return new SearchRequest(queryBuilder.buildQuery());
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstantStatisticsMapper that = (AbstractConstantStatisticsMapper)o;
        String constantType = this.getConstantType();
        if (constantType != null ? !constantType.equals(that.getConstantType()) : that.getConstantType() != null) {
            return false;
        }
        String documentConstant = this.getDocumentConstant();
        return documentConstant != null ? documentConstant.equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        int result = this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
        result = 29 * result + (this.getConstantType() != null ? this.getConstantType().hashCode() : 0);
        return result;
    }
}

