/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.lang;

import com.atlassian.jira.util.lang.JiraStringUtils;
import com.google.common.base.Preconditions;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@ThreadSafe
public final class Pair<F, S> {
    private final F first;
    private final S second;

    public static <U, V> Pair<U, V> of(U first, V second) {
        return Pair.strictPairOf(first, second);
    }

    public static <U, V> Pair<U, V> strictPairOf(U first, V second) {
        return new Pair<Object, Object>(Preconditions.checkNotNull(first, (Object)"first"), Preconditions.checkNotNull(second, (Object)"second"));
    }

    public static <U, V> Pair<U, V> nicePairOf(U first, V second) {
        return new Pair<U, V>(first, second);
    }

    private Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public F first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.first).append(this.second).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair that = (Pair)o;
        return new EqualsBuilder().append(this.first, that.first).append(this.second, that.second).isEquals();
    }

    public String toString() {
        return JiraStringUtils.asString("Pair[", "first=", this.first, ", second=", this.second, "]");
    }
}

