/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.core.util.StaticCrowdServiceFactory;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.util.OSUserConverter;
import com.google.common.base.Preconditions;
import com.opensymphony.util.TextUtils;

public class NotificationRecipient {
    public static final String MIMETYPE_HTML = "html";
    public static final String MIMETYPE_HTML_DISPLAY = "HTML";
    public static final String MIMETYPE_TEXT = "text";
    public static final String MIMETYPE_TEXT_DISPLAY = "Text";
    private final User user;
    private final String email;
    private final String format;

    public NotificationRecipient(User user) {
        this.user = (User)Preconditions.checkNotNull((Object)user);
        this.email = user.getEmailAddress();
        JiraUserPreferences userPrefs = new JiraUserPreferences(user);
        String prefFormat = userPrefs.getString("user.notifications.mimetype");
        this.format = TextUtils.stringSet((String)prefFormat) && (prefFormat.equals(MIMETYPE_HTML) || prefFormat.equals(MIMETYPE_TEXT)) ? prefFormat : MIMETYPE_TEXT;
    }

    public NotificationRecipient(String pEmail) {
        this.user = null;
        this.email = pEmail;
        this.format = MIMETYPE_TEXT;
    }

    public String getEmail() {
        return this.email;
    }

    public com.opensymphony.user.User getUser() {
        return OSUserConverter.convertToOSUser(this.user);
    }

    public User getUserRecipient() {
        return this.user;
    }

    public boolean isHtml() {
        return MIMETYPE_HTML.equals(this.format);
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isInGroup(String groupName) {
        return this.user != null && StaticCrowdServiceFactory.getCrowdService().isUserMemberOfGroup(this.user.getName(), groupName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationRecipient)) {
            return false;
        }
        NotificationRecipient notificationRecipient = (NotificationRecipient)o;
        if (this.email != null ? !this.email.equals(notificationRecipient.email) : notificationRecipient.email != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(notificationRecipient.user) : notificationRecipient.user != null);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.hashCode() : 0;
        result = 29 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }
}

