/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

public class SupportedOperatorsValidator {
    private final Collection<Operator> supportedOperators;

    public SupportedOperatorsValidator(Collection<Operator> ... supportedOperatorSets) {
        EnumSet<Operator> tmpOperators = EnumSet.noneOf(Operator.class);
        for (Collection<Operator> supportedOperatorSet : supportedOperatorSets) {
            tmpOperators.addAll(supportedOperatorSet);
        }
        this.supportedOperators = Collections.unmodifiableSet(tmpOperators);
    }

    public MessageSet validate(com.opensymphony.user.User searcher, TerminalClause terminalClause) {
        return this.validate((User)searcher, terminalClause);
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        Operator operator = terminalClause.getOperator();
        if (!this.supportedOperators.contains((Object)operator)) {
            I18nHelper i18n = this.getI18n(searcher);
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.does.not.support.operator", operator.getDisplayString(), terminalClause.getName()));
        }
        return messageSet;
    }

    I18nHelper getI18n(User user) {
        return ComponentAccessor.getI18nHelperFactory().getInstance(user);
    }
}

