/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.core.util.RandomGenerator;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.service.util.handler.MessageErrorHandler;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.OSUserConverter;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.atlassian.mail.MailUtils;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractMessageHandler
implements MessageHandler {
    protected final Logger log;
    protected static final String KEY_REPORTER = "reporterusername";
    protected static final String KEY_CATCHEMAIL = "catchemail";
    protected static final String KEY_CREATEUSERS = "createusers";
    protected static final String KEY_NOTIFYUSERS = "notifyusers";
    protected static final String KEY_FINGER_PRINT = "fingerprint";
    static final String VALUE_FINGER_PRINT_ACCEPT = "accept";
    static final String VALUE_FINGER_PRINT_FORWARD = "forward";
    static final String VALUE_FINGER_PRINT_IGNORE = "ignore";
    private final List VALUES_FINGERPRINT = EasyList.build((Object)"accept", (Object)"forward", (Object)"ignore");
    protected static final String KEY_BULK = "bulk";
    private static final String VALUE_BULK_IGNORE = "ignore";
    private static final String VALUE_BULK_FORWARD = "forward";
    private static final String VALUE_BULK_DELETE = "delete";
    protected static final String CONTENT_TYPE_TEXT = "text/plain";
    protected static final String HEADER_MESSAGE_ID = "message-id";
    protected static final String HEADER_IN_REPLY_TO = "in-reply-to";
    private static final String ATTACHED_MESSAGE_FILENAME = "attachedmessage";
    private static final String DEFAULT_BINARY_FILE_NAME = "binary.bin";
    protected boolean deleteEmail;
    private MessageErrorHandler errorHandler;
    protected Map params = new HashMap();
    public String reporteruserName;
    public String catchEmail;
    public String bulk;
    public boolean createUsers;
    public boolean notifyUsers;
    private String fingerPrintPolicy;
    protected final CommentManager commentManager;
    protected final IssueFactory issueFactory;
    protected final ApplicationProperties applicationProperties;
    private final JiraApplicationContext jiraApplicationContext;
    private static final FileNameCharacterCheckerUtil fileNameCharacterCheckerUtil = new FileNameCharacterCheckerUtil();
    private static final char INVALID_CHAR_REPLACEMENT = '_';

    protected AbstractMessageHandler() {
        this(ComponentAccessor.getComponent(CommentManager.class), ComponentAccessor.getComponent(IssueFactory.class), ComponentAccessor.getApplicationProperties(), ComponentAccessor.getComponent(JiraApplicationContext.class));
    }

    protected AbstractMessageHandler(CommentManager commentManager, IssueFactory issueFactory, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext) {
        this.commentManager = commentManager;
        this.issueFactory = issueFactory;
        this.applicationProperties = applicationProperties;
        this.jiraApplicationContext = jiraApplicationContext;
        MailLoggingManager mailLoggingManager = ComponentAccessor.getComponent(MailLoggingManager.class);
        this.log = mailLoggingManager.getIncomingMailChildLogger(ClassUtils.getShortClassName(this.getClass()));
    }

    @Override
    public void init(Map params) {
        this.params = params;
        if (params.containsKey(KEY_REPORTER)) {
            this.reporteruserName = (String)params.get(KEY_REPORTER);
        }
        if (params.containsKey(KEY_CATCHEMAIL)) {
            this.catchEmail = (String)params.get(KEY_CATCHEMAIL);
        }
        if (params.containsKey(KEY_BULK)) {
            this.bulk = (String)params.get(KEY_BULK);
        }
        if (params.containsKey(KEY_CREATEUSERS)) {
            this.createUsers = Boolean.valueOf((String)params.get(KEY_CREATEUSERS));
            if (this.createUsers) {
                boolean extUserMgmt = this.applicationProperties.getOption("jira.option.user.externalmanagement");
                if (this.reporteruserName != null) {
                    if (extUserMgmt) {
                        this.log.warn((Object)("Default Reporter Username set to '" + this.reporteruserName + "', " + KEY_CREATEUSERS + " is set to true and external user management is enabled."));
                        this.log.warn((Object)("Ignoring the createusers flag. Using the default Reporter username '" + this.reporteruserName + "'."));
                    } else {
                        this.log.warn((Object)("Default Reporter Username set to '" + this.reporteruserName + "' and " + KEY_CREATEUSERS + " is set to true."));
                        this.log.warn((Object)"Ignoring the Default Reporter Username, users will be created if they do not exist.");
                    }
                } else if (extUserMgmt) {
                    this.log.warn((Object)"createusers is set to true, but external user managment is enabled.  Users will NOT be created.");
                }
            }
            this.notifyUsers = !params.containsKey(KEY_NOTIFYUSERS) || Boolean.parseBoolean((String)params.get(KEY_NOTIFYUSERS));
        } else {
            this.log.debug((Object)"Defaulting to not creating users");
            this.createUsers = false;
            this.log.debug((Object)"Defaulting to notifying users since user creation is not specified");
            this.notifyUsers = true;
        }
        if (params.containsKey(KEY_FINGER_PRINT) && this.VALUES_FINGERPRINT.contains(params.get(KEY_FINGER_PRINT))) {
            this.fingerPrintPolicy = (String)params.get(KEY_FINGER_PRINT);
        } else {
            this.log.debug((Object)"Defaulting to fingerprint policy of 'forward'");
            this.fingerPrintPolicy = "forward";
        }
    }

    @Override
    public abstract boolean handleMessage(Message var1) throws MessagingException;

    protected boolean canHandleMessage(Message message) {
        this.deleteEmail = false;
        if (!this.fingerPrintCheck(message)) {
            return false;
        }
        if (this.checkBulk(message)) {
            return false;
        }
        if (this.catchEmail != null) {
            boolean forCatchAll;
            try {
                forCatchAll = MailUtils.hasRecipient((String)this.catchEmail, (Message)message);
            }
            catch (MessagingException exception) {
                this.deleteEmail = false;
                this.log.debug((Object)"Could not parse message recipients. Assuming message is bad.", (Throwable)exception);
                this.addError(this.getI18nBean().getText("admin.errors.bad.destination.address"), (Exception)((Object)exception));
                return false;
            }
            if (!forCatchAll) {
                this.deleteEmail = false;
                this.logCantHandleRecipients(message);
                return false;
            }
            this.deleteEmail = true;
        }
        return true;
    }

    private boolean checkBulk(Message message) {
        try {
            if ((KEY_BULK.equalsIgnoreCase(this.getPrecedenceHeader(message)) || this.isDeliveryStatus(message) || this.isAutoSubmitted(message)) && this.bulk != null) {
                if ("ignore".equalsIgnoreCase(this.bulk)) {
                    this.log.debug((Object)"Ignoring email with bulk delivery type");
                    this.deleteEmail = false;
                    return true;
                }
                if ("forward".equalsIgnoreCase(this.bulk)) {
                    this.log.debug((Object)"Forwarding email with bulk delivery type");
                    this.addError(this.getI18nBean().getText("admin.forward.bulk.mail"));
                    this.deleteEmail = false;
                    return true;
                }
                if (VALUE_BULK_DELETE.equalsIgnoreCase(this.bulk)) {
                    this.log.debug((Object)"Deleting email with bulk delivery type");
                    this.deleteEmail = true;
                    return true;
                }
            }
            return false;
        }
        catch (MessagingException mex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error occured while looking for bulk headers - assuming not bulk email: " + mex.getMessage()), (Throwable)mex);
            }
            return false;
        }
    }

    boolean fingerPrintCheck(Message message) {
        boolean fingerPrintClean = true;
        List<String> fingerPrintHeaders = this.getFingerPrintHeader(message);
        String instanceFingerPrint = this.jiraApplicationContext.getFingerPrint();
        if (!fingerPrintHeaders.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JIRA fingerprints found on on incoming email message: ");
                for (String fingerPrintHeader : fingerPrintHeaders) {
                    this.log.debug((Object)("fingerprint: " + fingerPrintHeader));
                }
            }
            if (fingerPrintHeaders.contains(instanceFingerPrint)) {
                this.log.warn((Object)("Received message carrying this JIRA instance fingerprint (" + instanceFingerPrint + ")"));
                if (VALUE_FINGER_PRINT_ACCEPT.equalsIgnoreCase(this.fingerPrintPolicy)) {
                    this.log.warn((Object)"Handler is configured to accept such messages. Beware of mail loops: JRA-12467");
                } else if ("forward".equalsIgnoreCase(this.fingerPrintPolicy)) {
                    this.log.debug((Object)"Forwarding fingerprinted email.");
                    this.addError(this.getI18nBean().getText("admin.forward.mail.loop"));
                    fingerPrintClean = false;
                } else if ("ignore".equalsIgnoreCase(this.fingerPrintPolicy)) {
                    this.log.info((Object)"Handler is configured to ignore this message.");
                    fingerPrintClean = false;
                }
            } else {
                this.log.info((Object)"Received message with another JIRA instance's fingerprint");
            }
        }
        return fingerPrintClean;
    }

    List<String> getFingerPrintHeader(Message message) {
        List<String> headers = Collections.emptyList();
        try {
            String[] headerArray = message.getHeader("X-JIRA-FingerPrint");
            if (headerArray != null) {
                headers = Arrays.asList(headerArray);
            }
        }
        catch (MessagingException e) {
            this.log.error((Object)"Failed to get mail header X-JIRA-FingerPrint");
        }
        return headers;
    }

    protected Collection<ChangeItemBean> createAttachmentsForMessage(Message message, GenericValue issue) throws IOException, MessagingException {
        ArrayList<ChangeItemBean> attachmentChangeItems = new ArrayList<ChangeItemBean>();
        if (this.applicationProperties.getOption("jira.option.allowattachments")) {
            String disposition = message.getDisposition();
            if (message.getContent() instanceof Multipart) {
                Multipart multipart = (Multipart)message.getContent();
                Collection<ChangeItemBean> changeItemBeans = this.handleMultipart(multipart, message, issue);
                if (changeItemBeans != null && !changeItemBeans.isEmpty()) {
                    attachmentChangeItems.addAll(changeItemBeans);
                }
            } else if ("attachment".equalsIgnoreCase(disposition)) {
                ChangeItemBean res;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Trying to add attachment to issue from attachment only message.");
                }
                if ((res = this.saveAttachmentIfNecessary((Part)message, null, this.getReporter(message), issue)) != null) {
                    attachmentChangeItems.add(res);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Unable to add message attachements to issue: JIRA Attachements are disabled.");
        }
        return attachmentChangeItems;
    }

    private Collection<ChangeItemBean> handleMultipart(Multipart multipart, Message message, GenericValue issue) throws MessagingException, IOException {
        ArrayList<ChangeItemBean> attachmentChangeItems = new ArrayList<ChangeItemBean>();
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part;
            boolean isContentMultipart;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Adding attachments for multi-part message. Part %d of %d.", i + 1, n));
            }
            if (isContentMultipart = (part = multipart.getBodyPart(i)).getContent() instanceof Multipart) {
                attachmentChangeItems.addAll(this.handleMultipart((Multipart)part.getContent(), message, issue));
                continue;
            }
            ChangeItemBean res = this.saveAttachmentIfNecessary((Part)part, message, this.getReporter(message), issue);
            if (res == null) continue;
            attachmentChangeItems.add(res);
        }
        return attachmentChangeItems;
    }

    private boolean isMessageInReplyToAnother(Message containingMessage, Message attachedMessage) throws MessagingException, ParseException {
        String attachMessageId = this.getMessageId(attachedMessage);
        Object[] replyToIds = containingMessage.getHeader(HEADER_IN_REPLY_TO);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Checking if attachment was reply to containing message:");
            this.log.debug((Object)("\tAttachment mesage id: " + attachMessageId));
            this.log.debug((Object)("\tNew message reply to values: " + Arrays.toString(replyToIds)));
        }
        if (replyToIds != null) {
            for (String string : replyToIds) {
                if (string == null || !string.equalsIgnoreCase(attachMessageId)) continue;
                return true;
            }
        }
        return false;
    }

    String getMessageId(Message message) throws MessagingException, ParseException {
        String[] originalMessageIds = message.getHeader(HEADER_MESSAGE_ID);
        if (originalMessageIds == null || originalMessageIds.length == 0) {
            String msg = "Could not retrieve Message-ID header from message: " + message;
            this.log.debug((Object)msg);
            throw new ParseException(msg);
        }
        return originalMessageIds[0];
    }

    private ChangeItemBean saveAttachmentIfNecessary(Part part, Message containingMessage, com.opensymphony.user.User reporter, GenericValue issue) throws MessagingException, IOException {
        boolean keep = this.shouldAttach(part, containingMessage);
        if (keep) {
            return this.createAttachmentWithPart(part, reporter, issue);
        }
        return null;
    }

    protected final boolean shouldAttach(Part part, Message containingMessage) throws MessagingException, IOException {
        boolean attach;
        Assertions.notNull("part", part);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Checking if attachment should be added to issue:");
            this.log.debug((Object)("\tContent-Type: " + part.getContentType()));
            this.log.debug((Object)("\tContent-Disposition: " + part.getDisposition()));
        }
        if (MailUtils.isPartMessageType((Part)part) && null != containingMessage) {
            this.log.debug((Object)"Attachment detected as a rfc/822 message.");
            attach = this.attachMessagePart(part, containingMessage);
        } else if (MailUtils.isPartAttachment((Part)part)) {
            this.log.debug((Object)"Attachment detected as an 'Attachment'.");
            attach = this.attachAttachmentsParts(part);
        } else if (MailUtils.isPartInline((Part)part)) {
            this.log.debug((Object)"Attachment detected as an inline element.");
            attach = this.attachInlineParts(part);
        } else if (MailUtils.isPartPlainText((Part)part)) {
            this.log.debug((Object)"Attachment detected as plain text.");
            attach = this.attachPlainTextParts(part);
        } else if (MailUtils.isPartHtml((Part)part)) {
            this.log.debug((Object)"Attachment detected as HTML.");
            attach = this.attachHtmlParts(part);
        } else if (MailUtils.isPartRelated((Part)containingMessage)) {
            this.log.debug((Object)"Attachment detected as related content.");
            attach = this.attachRelatedPart(part);
        } else {
            attach = false;
        }
        if (this.log.isDebugEnabled()) {
            if (attach) {
                this.log.debug((Object)"Attachment was added to issue");
            } else {
                this.log.debug((Object)"Attachment was ignored.");
            }
        }
        return attach;
    }

    protected abstract boolean attachPlainTextParts(Part var1) throws MessagingException, IOException;

    protected abstract boolean attachHtmlParts(Part var1) throws MessagingException, IOException;

    protected boolean attachInlineParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && !MailUtils.isPartSignaturePKCS7((Part)part);
    }

    protected boolean attachAttachmentsParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && !MailUtils.isPartSignaturePKCS7((Part)part);
    }

    protected boolean attachMessagePart(Part messagePart, Message containingMessage) throws IOException, MessagingException {
        boolean keep = false;
        if (!this.shouldIgnoreEmailMessageAttachments()) {
            if (!this.isReplyMessagePart(messagePart, containingMessage)) {
                boolean bl = keep = !MailUtils.isContentEmpty((Part)messagePart);
                if (!keep && this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Attachment not attached to issue: Message is empty.");
                }
            } else {
                this.log.debug((Object)"Attachment not attached to issue: Detected as reply.");
            }
        } else {
            this.log.debug((Object)"Attachment not attached to issue: Message attachment has been disabled.");
        }
        return keep;
    }

    protected boolean attachRelatedPart(Part part) throws IOException, MessagingException {
        return !MailUtils.isContentEmpty((Part)part);
    }

    boolean shouldIgnoreEmailMessageAttachments() {
        return this.applicationProperties.getOption("jira.option.ignore.email.message.attachments");
    }

    private boolean isReplyMessagePart(Part messagePart, Message containingMessage) throws IOException, MessagingException {
        boolean replyMessage;
        try {
            replyMessage = this.isMessageInReplyToAnother(containingMessage, (Message)messagePart.getContent());
        }
        catch (ParseException e) {
            this.log.debug((Object)"Can't tell if the message is in reply to the attached message -- will attach it in case");
            replyMessage = false;
        }
        return replyMessage;
    }

    protected ChangeItemBean createAttachmentWithPart(Part part, com.opensymphony.user.User reporter, GenericValue issue) throws IOException {
        try {
            AttachmentManager attachmentManager;
            ChangeItemBean cib;
            String contentType = MailUtils.getContentType((Part)part);
            String rawFilename = part.getFileName();
            String filename = this.getFilenameForAttachment(part);
            File file = this.getFileFromPart(part, issue != null ? issue.getString("key") : "null");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("part=" + part));
                this.log.debug((Object)("Filename=" + filename + ", content type=" + contentType + ", content=" + part.getContent()));
            }
            if ((cib = (attachmentManager = this.getAttachmentManager()).createAttachment(file, filename = this.renameFileIfInvalid(filename, issue, reporter), contentType, reporter, issue)) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Created attachment " + rawFilename + " for issue " + issue.get("key")));
                }
                return cib;
            }
            this.log.debug((Object)("Encountered an error creating the attachment " + rawFilename + " for issue " + issue.get("key")));
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("Exception while creating attachment for issue " + (issue != null ? issue.getString("key") : "null") + ": " + e), (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected String getFilenameForAttachment(Part part) throws MessagingException, IOException {
        String filename = this.getFilenameFromPart(part);
        if (null == filename) {
            if (MailUtils.isPartMessageType((Part)part)) {
                filename = this.getFilenameFromMessageSubject(part);
            } else if (MailUtils.isPartInline((Part)part)) {
                filename = this.getFilenameFromContentType(part);
            }
        }
        if (null != filename && StringUtils.isBlank((String)filename)) {
            String message = "Having found a filename(aka filename is not null) filename should not be an empty string, but is...";
            this.log.warn((Object)"Having found a filename(aka filename is not null) filename should not be an empty string, but is...");
            filename = null;
        }
        return filename;
    }

    private String getFilenameFromPart(Part part) throws MessagingException, IOException {
        String filename = part.getFileName();
        if (null != filename) {
            filename = MailUtils.fixMimeEncodedFilename((String)filename);
        }
        return filename;
    }

    private String getFilenameFromMessageSubject(Part part) throws MessagingException, IOException {
        Message message = (Message)part.getContent();
        String filename = message.getSubject();
        if (StringUtils.isBlank((String)filename)) {
            try {
                filename = this.getMessageId(message);
            }
            catch (ParseException e) {
                filename = ATTACHED_MESSAGE_FILENAME;
            }
        }
        return filename;
    }

    private String getFilenameFromContentType(Part part) throws MessagingException, IOException {
        String subMimeType;
        String filename = DEFAULT_BINARY_FILE_NAME;
        String contentType = MailUtils.getContentType((Part)part);
        int slash = contentType.indexOf("/");
        if (-1 != slash && !(subMimeType = contentType.substring(slash + 1)).equals("bin")) {
            filename = contentType.substring(0, slash) + '.' + subMimeType;
        }
        return filename;
    }

    protected String renameFileIfInvalid(String filename, GenericValue issue, com.opensymphony.user.User reporter) {
        if (filename == null) {
            return null;
        }
        String replacedFilename = fileNameCharacterCheckerUtil.replaceInvalidChars(filename, '_');
        if (!filename.equals(replacedFilename)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Filename was invalid: replacing '" + filename + "' with '" + replacedFilename + "'"));
            }
            this.commentManager.create(this.issueFactory.getIssue(issue), reporter.getName(), this.getI18nBean().getText("admin.renamed.file.cause.of.invalid.chars", filename, replacedFilename), false);
            return replacedFilename;
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getFileFromPart(Part part, String issueKey) throws IOException, MessagingException, GenericEntityException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempattach", "dat");
            FileOutputStream out = new FileOutputStream(tempFile);
            try {
                part.getDataHandler().writeTo((OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Problem reading attachment from email for issue " + issueKey), (Throwable)e);
        }
        if (tempFile == null) {
            throw new IOException("Unable to create file?");
        }
        return tempFile;
    }

    AttachmentManager getAttachmentManager() {
        return ComponentAccessor.getAttachmentManager();
    }

    protected com.opensymphony.user.User getReporter(Message message) throws MessagingException {
        com.opensymphony.user.User reporter = this.getAuthorFromSender(message);
        if (reporter == null) {
            if (this.createUsers) {
                reporter = this.createUserForReporter(message);
            }
            if (this.reporteruserName != null && reporter == null) {
                reporter = OSUserConverter.convertToOSUser(UserUtils.getUser(this.reporteruserName));
                this.log.info((Object)("Sender not registered in JIRA. Using configured default reporter '" + this.reporteruserName + "'."));
            }
        }
        return reporter;
    }

    com.opensymphony.user.User getAuthorFromSender(Message message) throws MessagingException {
        String emailAddress;
        List senders = MailUtils.getSenders((Message)message);
        com.opensymphony.user.User user = null;
        Iterator i$ = senders.iterator();
        while (i$.hasNext() && (user = this.findUserByEmail(emailAddress = (String)i$.next())) == null && (user = this.findUserByUsername(emailAddress)) == null) {
        }
        return user;
    }

    protected com.opensymphony.user.User findUserByUsername(String username) {
        return OSUserConverter.convertToOSUser(UserUtils.getUser(username));
    }

    protected com.opensymphony.user.User findUserByEmail(String emailAddress) {
        for (User user : UserUtils.getAllUsers()) {
            if (!emailAddress.equalsIgnoreCase(user.getEmailAddress())) continue;
            return OSUserConverter.convertToOSUser(user);
        }
        return null;
    }

    protected com.opensymphony.user.User createUserForReporter(Message message) {
        com.opensymphony.user.User reporter = null;
        try {
            if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
                this.log.warn((Object)"External user management is enabled. Contact your Administrator");
                return null;
            }
            this.log.debug((Object)"Cannot find reporter for message. Creating new user.");
            InternetAddress internetAddress = (InternetAddress)message.getFrom()[0];
            String reporterEmail = internetAddress.getAddress();
            if (!TextUtils.verifyEmail((String)reporterEmail)) {
                this.log.error((Object)("The email address [" + reporterEmail + "] received was not valid. Ensure that your mail client specified a valid 'From:' mail header. (see JRA-12203)"));
                return null;
            }
            String fullName = internetAddress.getPersonal();
            if (fullName == null || fullName.trim().length() == 0) {
                fullName = reporterEmail;
            }
            String password = RandomGenerator.randomPassword();
            UserUtil userUtil = ComponentAccessor.getUserUtil();
            reporter = this.notifyUsers ? userUtil.createUserWithEvent(reporterEmail, password, reporterEmail, fullName, 1) : userUtil.createUserNoEvent(reporterEmail, password, reporterEmail, fullName);
            this.log.debug((Object)("Created user " + reporterEmail + " as reporter of email-based issue."));
        }
        catch (Exception e) {
            this.log.error((Object)"Error occurred while automatically creating a new user from email: ", (Throwable)e);
        }
        return reporter;
    }

    protected String getPrecedenceHeader(Message message) throws MessagingException {
        String precedenceHeader;
        String[] precedenceHeaders = message.getHeader("Precedence");
        if (precedenceHeaders != null && precedenceHeaders.length > 0 && !StringUtils.isBlank((String)(precedenceHeader = precedenceHeaders[0]))) {
            return precedenceHeader;
        }
        return null;
    }

    protected boolean isDeliveryStatus(Message message) throws MessagingException {
        String contentType = message.getContentType();
        if ("multipart/report".equalsIgnoreCase(MailUtils.getContentType((String)contentType))) {
            return contentType.toLowerCase().contains("report-type=delivery-status");
        }
        return false;
    }

    protected boolean isAutoSubmitted(Message message) throws MessagingException {
        String[] autoSub = message.getHeader("Auto-Submitted");
        if (autoSub != null) {
            for (String auto : autoSub) {
                if ("no".equalsIgnoreCase(auto)) continue;
                return true;
            }
        }
        return false;
    }

    protected void recordMessageId(String type, Message message, Long issueId) throws MessagingException {
        String[] messageIds = message.getHeader("Message-Id");
        if (messageIds != null && messageIds.length > 0) {
            Address[] froms = message.getFrom();
            String fromAddress = null;
            if (froms != null && froms.length > 0) {
                fromAddress = ((InternetAddress)froms[0]).getAddress();
            }
            ComponentAccessor.getMailThreadManager().createMailThread(type, issueId, fromAddress, messageIds[0]);
        }
    }

    protected GenericValue getAssociatedIssue(Message message) {
        return ComponentAccessor.getMailThreadManager().getAssociatedIssue(message);
    }

    @Override
    public void setErrorHandler(MessageErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void addError(String error) {
        if (this.errorHandler != null) {
            this.errorHandler.setError(error);
        }
    }

    public void addError(String error, Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.setError(error, e);
        }
    }

    public boolean addErrorAndReturnFalse(String error) {
        this.addError(error);
        return false;
    }

    public boolean addErrorAndReturnFalse(String error, Exception e) {
        this.addError(error, e);
        return false;
    }

    protected MessageErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    private void logCantHandleRecipients(Message message) {
        Address[] addresses;
        try {
            addresses = message.getAllRecipients();
        }
        catch (MessagingException e) {
            this.log.debug((Object)"Cannot handle message. Unable to parse recipient addresses.", (Throwable)e);
            return;
        }
        if (addresses == null || addresses.length == 0) {
            this.log.debug((Object)"Cannot handle message.  No recipient addresses found.");
        } else {
            StringBuffer recipients = new StringBuffer();
            for (int i = 0; i < addresses.length; ++i) {
                InternetAddress email = (InternetAddress)addresses[i];
                if (email == null) continue;
                recipients.append(email.getAddress());
                if (i + 1 >= addresses.length) continue;
                recipients.append(", ");
            }
            this.log.debug((Object)("Cannot handle message as the recipient(s) (" + recipients.toString() + ") do not match the catch email " + this.catchEmail));
        }
    }

    void setFingerPrintPolicy(String fingerPrintPolicy) {
        this.fingerPrintPolicy = fingerPrintPolicy;
    }
}

