/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChangeHistoryItem
implements Comparable<ChangeHistoryItem> {
    private final Long id;
    private final String user;
    private final String field;
    private final Long projectId;
    private final Long issueId;
    private final String issueKey;
    private final Timestamp created;
    private final Timestamp nextChangeCreated;
    private final String from;
    private final String to;
    private final String fromValue;
    private final String toValue;
    private static final Timestamp TS_MAX = new Timestamp(Long.MAX_VALUE);

    public ChangeHistoryItem(Long id, Long projectId, Long issueId, String issueKey, String field, Timestamp created, String from, String to, String fromValue, String toValue, String user) {
        this.id = id;
        this.user = user;
        this.projectId = projectId;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.created = created;
        this.nextChangeCreated = new Timestamp(Long.MAX_VALUE);
        this.from = from;
        this.to = to;
        this.field = field;
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    public ChangeHistoryItem(Long id, Long projectId, Long issueId, String issueKey, String field, Timestamp created, Timestamp nextChange, String from, String to, String fromValue, String toValue, String user) {
        this.id = id;
        this.user = user;
        this.projectId = projectId;
        this.issueId = issueId;
        this.issueKey = issueKey;
        this.created = created;
        this.nextChangeCreated = nextChange;
        this.from = from;
        this.to = to;
        this.field = field;
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    public Long getId() {
        return this.id;
    }

    public String getUser() {
        return this.user;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getField() {
        return this.field;
    }

    public String getFromValue() {
        return this.fromValue;
    }

    public String getToValue() {
        return this.toValue;
    }

    public Timestamp getNextChangeCreated() {
        return this.nextChangeCreated;
    }

    public Long getDuration() {
        if (this.nextChangeCreated.equals(TS_MAX)) {
            return -1L;
        }
        return this.nextChangeCreated.getTime() - this.created.getTime();
    }

    @Override
    public int compareTo(ChangeHistoryItem other) {
        if (this.created.compareTo(other.getCreated()) == 0) {
            return this.id.compareTo(other.getId());
        }
        return this.created.compareTo(other.getCreated());
    }

    public static class Builder {
        private long id;
        private long projectId;
        private long issueId;
        private String issueKey;
        private String field;
        private Timestamp created;
        private String from;
        private String fromValue;
        private String to;
        private String toValue;
        private String userName;
        private Timestamp nextChangeCreated = new Timestamp(Long.MAX_VALUE);

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder inProject(long projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        public Builder forIssue(long issueId, String issueKey) {
            Preconditions.checkNotNull((Object)issueId);
            Preconditions.checkNotNull((Object)issueKey);
            this.issueId = issueId;
            this.issueKey = issueKey;
            return this;
        }

        public Builder field(String field) {
            Preconditions.checkNotNull((Object)field);
            this.field = field;
            return this;
        }

        public Builder changedFrom(String from, String fromValue) {
            this.from = from;
            this.fromValue = fromValue;
            return this;
        }

        public Builder to(String to, String toValue) {
            this.to = to;
            this.toValue = toValue;
            return this;
        }

        public Builder byUser(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder on(Timestamp created) {
            Preconditions.checkNotNull((Object)created);
            this.created = created;
            return this;
        }

        public Builder nextChangeOn(Timestamp nextChangeCreated) {
            this.nextChangeCreated = nextChangeCreated;
            return this;
        }

        public ChangeHistoryItem build() {
            return new ChangeHistoryItem(this.id, this.projectId, this.issueId, this.issueKey, this.field, this.created, this.nextChangeCreated, this.from, this.to, this.fromValue, this.toValue, this.userName);
        }
    }
}

